/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class AbstractImageHeapLayouter<T extends ImageHeapPartition>
implements ImageHeapLayouter {
    private static final int READ_ONLY_PRIMITIVE = 0;
    private static final int READ_ONLY_REFERENCE = 1;
    private static final int READ_ONLY_RELOCATABLE = 2;
    private static final int WRITABLE_PRIMITIVE = 3;
    private static final int WRITABLE_REFERENCE = 4;
    private static final int PARTITION_COUNT = 5;
    private final T[] partitions = this.createPartitionsArray(5);

    public T[] getPartitions() {
        return this.partitions;
    }

    public AbstractImageHeapLayouter() {
        this.partitions[0] = this.createPartition("readOnlyPrimitive", false, false);
        this.partitions[1] = this.createPartition("readOnlyReference", true, false);
        this.partitions[2] = this.createPartition("readOnlyRelocatable", true, false);
        this.partitions[3] = this.createPartition("writablePrimitive", false, true);
        this.partitions[4] = this.createPartition("writableReference", true, true);
    }

    @Override
    public void assignObjectToPartition(ImageHeapObject info, boolean immutable, boolean references, boolean relocatable) {
        ImageHeapPartition partition = this.choosePartition(immutable, references, relocatable);
        info.setHeapPartition(partition);
    }

    @Override
    public ImageHeapLayout layoutPartitionsAsContiguousHeap(String sectionName, int pageSize) {
        VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue());
        this.getReadOnlyPrimitive().addPadding(AbstractImageHeapLayouter.computePadding(this.getReadOnlyPrimitive().getSize() + this.getReadOnlyReference().getSize(), pageSize));
        this.getReadOnlyRelocatable().addPadding(AbstractImageHeapLayouter.computePadding(this.getReadOnlyRelocatable().getSize(), pageSize));
        this.getReadOnlyPrimitive().setSection(sectionName, 0L);
        this.getReadOnlyReference().setSection(sectionName, this.getReadOnlyPrimitive().getOffsetInSection() + this.getReadOnlyPrimitive().getSize());
        this.getReadOnlyRelocatable().setSection(sectionName, this.getReadOnlyReference().getOffsetInSection() + this.getReadOnlyReference().getSize());
        this.getWritablePrimitive().setSection(sectionName, this.getReadOnlyRelocatable().getOffsetInSection() + this.getReadOnlyRelocatable().getSize());
        this.getWritableReference().setSection(sectionName, this.getWritablePrimitive().getOffsetInSection() + this.getWritablePrimitive().getSize());
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        assert (this.getReadOnlyPrimitive().getOffsetInSection() == 0L);
        assert (this.getReadOnlyReference().getOffsetInSection() % (long)objectAlignment == 0L);
        assert (this.getReadOnlyRelocatable().getOffsetInSection() % (long)pageSize == 0L);
        assert (this.getWritablePrimitive().getOffsetInSection() % (long)pageSize == 0L);
        assert (this.getWritableReference().getOffsetInSection() % (long)objectAlignment == 0L);
        return this.createLayout();
    }

    @Override
    public ImageHeapLayout layoutPartitionsAsSeparatedHeap(String readOnlySectionName, long readOnlySectionOffset, String writableSectionName, long writableSectionOffset) {
        VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue() == false);
        this.getReadOnlyPrimitive().setSection(readOnlySectionName, readOnlySectionOffset);
        this.getReadOnlyReference().setSection(readOnlySectionName, this.getReadOnlyPrimitive().getOffsetInSection() + this.getReadOnlyPrimitive().getSize());
        this.getReadOnlyRelocatable().setSection(readOnlySectionName, this.getReadOnlyReference().getOffsetInSection() + this.getReadOnlyReference().getSize());
        this.getWritablePrimitive().setSection(writableSectionName, writableSectionOffset);
        this.getWritableReference().setSection(writableSectionName, this.getWritablePrimitive().getOffsetInSection() + this.getWritablePrimitive().getSize());
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        assert (this.getReadOnlyPrimitive().getOffsetInSection() % (long)objectAlignment == 0L);
        assert (this.getReadOnlyReference().getOffsetInSection() % (long)objectAlignment == 0L);
        assert (this.getReadOnlyRelocatable().getOffsetInSection() % (long)objectAlignment == 0L);
        assert (this.getWritablePrimitive().getOffsetInSection() % (long)objectAlignment == 0L);
        assert (this.getWritableReference().getOffsetInSection() % (long)objectAlignment == 0L);
        return this.createLayout();
    }

    protected T getReadOnlyPrimitive() {
        return (T)this.getPartitions()[0];
    }

    protected T getReadOnlyReference() {
        return (T)this.getPartitions()[1];
    }

    protected T getReadOnlyRelocatable() {
        return (T)this.getPartitions()[2];
    }

    protected T getWritablePrimitive() {
        return (T)this.getPartitions()[3];
    }

    protected T getWritableReference() {
        return (T)this.getPartitions()[4];
    }

    private static long computePadding(long offset, int alignment) {
        long remainder = offset % (long)alignment;
        return remainder == 0L ? 0L : (long)alignment - remainder;
    }

    private ImageHeapPartition choosePartition(boolean immutable, boolean references, boolean relocatable) {
        if (SubstrateOptions.UseOnlyWritableBootImageHeap.getValue().booleanValue() && !AbstractImageHeapLayouter.useHeapBase()) {
            return this.getWritableReference();
        }
        if (immutable) {
            if (relocatable) {
                return this.getReadOnlyRelocatable();
            }
            return references ? this.getReadOnlyReference() : this.getReadOnlyPrimitive();
        }
        return references ? this.getWritableReference() : this.getWritablePrimitive();
    }

    private ImageHeapLayout createLayout() {
        long readOnlySectionSize = this.getReadOnlyPrimitive().getSize() + this.getReadOnlyReference().getSize() + this.getReadOnlyRelocatable().getSize();
        long writableSectionSize = this.getWritablePrimitive().getSize() + this.getWritableReference().getSize();
        long readOnlyRelocatableOffsetInSection = this.getReadOnlyRelocatable().getOffsetInSection();
        long readOnlyRelocatableSize = this.getReadOnlyRelocatable().getSize();
        return new ImageHeapLayout(this.getReadOnlyPrimitive().getOffsetInSection(), readOnlySectionSize, this.getWritablePrimitive().getOffsetInSection(), writableSectionSize, readOnlyRelocatableOffsetInSection, readOnlyRelocatableSize);
    }

    @Fold
    protected static boolean useHeapBase() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    protected abstract T[] createPartitionsArray(int var1);

    protected abstract T createPartition(String var1, boolean var2, boolean var3);

    public static abstract class AbstractImageHeapPartition
    implements ImageHeapPartition {
        private static final long INVALID_SECTION_OFFSET = -1L;
        private final String name;
        private final boolean writable;
        private String sectionName;
        private long offsetInSection;

        public AbstractImageHeapPartition(String name, boolean writable) {
            this.name = name;
            this.writable = writable;
            this.sectionName = null;
            this.offsetInSection = -1L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isWritable() {
            return this.writable;
        }

        @Override
        public void setSection(String sectionName, long offsetInSection) {
            this.sectionName = sectionName;
            this.offsetInSection = offsetInSection;
        }

        @Override
        public String getSectionName() {
            assert (this.sectionName != null) : "Partition " + this.name + " should have a section name by now.";
            return this.sectionName;
        }

        @Override
        public long getOffsetInSection() {
            assert (this.offsetInSection != -1L) : "Partition " + this.name + " should have an offset by now.";
            return this.offsetInSection;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ImageHeapLayout {
        private final long readOnlyOffsetInSection;
        private final long readOnlySize;
        private final long writableOffsetInSection;
        private final long writableSize;
        private final long readOnlyRelocatableOffsetInSection;
        private final long readOnlyRelocatableSize;

        public ImageHeapLayout(long readOnlyOffsetInSection, long readOnlySize, long writableOffsetInSection, long writableSize, long readOnlyRelocatableOffsetInSection, long readOnlyRelocatableSize) {
            this.readOnlyOffsetInSection = readOnlyOffsetInSection;
            this.readOnlySize = readOnlySize;
            this.writableOffsetInSection = writableOffsetInSection;
            this.writableSize = writableSize;
            this.readOnlyRelocatableOffsetInSection = readOnlyRelocatableOffsetInSection;
            this.readOnlyRelocatableSize = readOnlyRelocatableSize;
        }

        public long getReadOnlyOffsetInSection() {
            return this.readOnlyOffsetInSection;
        }

        public long getReadOnlySize() {
            return this.readOnlySize;
        }

        public long getWritableOffsetInSection() {
            return this.writableOffsetInSection;
        }

        public long getWritableSize() {
            return this.writableSize;
        }

        public long getReadOnlyRelocatableOffsetInSection() {
            return this.readOnlyRelocatableOffsetInSection;
        }

        public long getReadOnlyRelocatableSize() {
            return this.readOnlyRelocatableSize;
        }

        public boolean isReadOnlyRelocatable(int offset) {
            return (long)offset >= this.readOnlyRelocatableOffsetInSection && (long)offset < this.readOnlyRelocatableOffsetInSection + this.readOnlyRelocatableSize;
        }

        public long getImageHeapSize() {
            return this.getReadOnlySize() + this.getWritableSize();
        }
    }
}

