/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.jdk.StackTraceUtils;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.ReflectionGetCallerClassNode;

@NodeInfo
public final class SubstrateReflectionGetCallerClassNode
extends ReflectionGetCallerClassNode {
    public static final NodeClass<SubstrateReflectionGetCallerClassNode> TYPE = NodeClass.create(SubstrateReflectionGetCallerClassNode.class);
    private final MetaAccessProvider metaAccess;

    public SubstrateReflectionGetCallerClassNode(MetaAccessProvider metaAccess, MacroNode.MacroParams p) {
        super(TYPE, p);
        this.metaAccess = metaAccess;
    }

    protected boolean isCallerSensitive(ResolvedJavaMethod method) {
        return true;
    }

    protected boolean ignoredBySecurityStackWalk(ResolvedJavaMethod method) {
        return !StackTraceUtils.shouldShowFrame(this.metaAccess, method, false, false);
    }
}

