/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class Space {
    private final Accounting accounting;
    protected final String name;
    private final int age;
    private final boolean isFrom;
    private AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk;
    private AlignedHeapChunk.AlignedHeader lastAlignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk;

    public Accounting getAccounting() {
        return this.accounting;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.getFirstAlignedHeapChunk().isNull() && this.getFirstUnalignedHeapChunk().isNull();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected Space(String name, boolean isFrom, int age) {
        this.name = name;
        assert (name != null) : "Space name should not be null.";
        this.accounting = Accounting.factory();
        this.isFrom = isFrom;
        this.age = age;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.getFirstAlignedHeapChunk());
        HeapChunkProvider.freeUnalignedChunkList(this.getFirstUnalignedHeapChunk());
    }

    boolean isEdenSpace() {
        return this.age == 0;
    }

    boolean isYoungSpace() {
        return this.age <= HeapPolicy.getMaxSurvivorSpaces();
    }

    boolean isSurvivorSpace() {
        return this.age > 0 && this.age <= HeapPolicy.getMaxSurvivorSpaces();
    }

    boolean isOldSpace() {
        return this.age == HeapPolicy.getMaxSurvivorSpaces() + 1;
    }

    int getAge() {
        return this.age;
    }

    int getNextAgeForPromotion() {
        return this.age + 1;
    }

    boolean isFrom() {
        return this.isFrom;
    }

    public boolean walkObjects(ObjectVisitor visitor) {
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            if (!AlignedHeapChunk.walkObjectsOfAlignedHeapChunk(aChunk, visitor)) {
                return false;
            }
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            if (!UnalignedHeapChunk.walkObjectsOfUnalignedHeapChunk(uChunk, visitor)) {
                return false;
            }
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        return true;
    }

    public boolean walkDirtyObjects(ObjectVisitor visitor, boolean clean) {
        Log trace = Log.noopLog().string("[Space.walkDirtyObjects:");
        trace.string("  space: ").string(this.getName()).string("  clean: ").bool(clean);
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            trace.newline().string("  aChunk: ").hex((WordBase)aChunk);
            if (!AlignedHeapChunk.walkDirtyObjectsOfAlignedHeapChunk(aChunk, visitor, clean)) {
                Log failureLog = Log.log().string("[Space.walkDirtyObjects:");
                failureLog.string("  aChunk.walkDirtyObjects fails").string("]").newline();
                return false;
            }
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            trace.newline().string("  uChunk: ").hex((WordBase)uChunk);
            if (!UnalignedHeapChunk.walkDirtyObjectsOfUnalignedHeapChunk(uChunk, visitor, clean)) {
                Log failureLog = Log.log().string("[Space.walkDirtyObjects:");
                failureLog.string("  uChunk.walkDirtyObjects fails").string("]").newline();
                return false;
            }
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        trace.string("]").newline();
        return true;
    }

    public Log report(Log log, boolean traceHeapChunks) {
        log.string("[").string(this.getName()).string(":").indent(true);
        this.getAccounting().report(log);
        if (traceHeapChunks) {
            if (this.getFirstAlignedHeapChunk().isNonNull()) {
                log.newline().string("aligned chunks:").redent(true);
                AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
                while (aChunk.isNonNull()) {
                    log.newline().hex((WordBase)aChunk).string(" (").hex((WordBase)AlignedHeapChunk.getAlignedHeapChunkStart(aChunk)).string("-").hex((WordBase)aChunk.getTop()).string(")");
                    aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
                }
                log.redent(false);
            }
            if (this.getFirstUnalignedHeapChunk().isNonNull()) {
                log.newline().string("unaligned chunks:").redent(true);
                UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
                while (uChunk.isNonNull()) {
                    log.newline().hex((WordBase)uChunk).string(" (").hex((WordBase)UnalignedHeapChunk.getUnalignedHeapChunkStart(uChunk)).string("-").hex((WordBase)uChunk.getTop()).string(")");
                    uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
                }
                log.redent(false);
            }
        }
        log.redent(false).string("]");
        return log;
    }

    private Pointer allocateMemory(UnsignedWord objectSize) {
        Log trace = Log.noopLog().string("[Space.allocateMemory:").string("  space: ").string(this.getName()).string("  size: ").unsigned((WordBase)objectSize).newline();
        Pointer result = (Pointer)WordFactory.nullPointer();
        AlignedHeapChunk.AlignedHeader oldChunk = this.getLastAlignedHeapChunk();
        trace.string("  oldChunk: ").hex((WordBase)oldChunk);
        if (oldChunk.isNonNull()) {
            result = AlignedHeapChunk.allocateMemory(oldChunk, objectSize);
            trace.string("  oldChunk provides: ").hex((WordBase)result);
        }
        if (result.isNull()) {
            AlignedHeapChunk.AlignedHeader newChunk = this.requestAlignedHeapChunk();
            trace.string("  newChunk: ").hex((WordBase)newChunk);
            if (newChunk.isNonNull()) {
                result = AlignedHeapChunk.allocateMemory(newChunk, objectSize);
                if (this.isSurvivorSpace()) {
                    trace.string("  newSurvivorChunk provides: ").hex((WordBase)result);
                } else {
                    trace.string("  newChunk provides: ").hex((WordBase)result);
                }
            }
        }
        trace.string("  returns: ").hex((WordBase)result).string("]").newline();
        return result;
    }

    Object promoteObjectChunk(Object original) {
        if (ObjectHeaderImpl.isAlignedObject(original)) {
            AlignedHeapChunk.AlignedHeader aChunk = AlignedHeapChunk.getEnclosingAlignedHeapChunk(original);
            Space originalSpace = aChunk.getSpace();
            if (originalSpace.isFrom()) {
                this.promoteAlignedHeapChunk(aChunk, originalSpace);
            }
        } else {
            assert (ObjectHeaderImpl.isUnalignedObject(original));
            UnalignedHeapChunk.UnalignedHeader uChunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(original);
            Space originalSpace = uChunk.getSpace();
            if (originalSpace.isFrom()) {
                this.promoteUnalignedHeapChunk(uChunk, originalSpace);
            }
        }
        return original;
    }

    public void release() {
        this.releaseAlignedHeapChunks();
        this.releaseUnalignedHeapChunks();
        this.getAccounting().reset();
    }

    void cleanRememberedSet() {
        this.cleanRememberedSetAlignedHeapChunks();
        this.cleanRememberedSetUnalignedHeapChunk();
    }

    private void cleanRememberedSetAlignedHeapChunks() {
        Log trace = Log.noopLog().string("[Space.cleanAlignedHeapChunks:").string("  space: ").string(this.getName());
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            trace.newline().string("  aChunk: ").hex((WordBase)aChunk);
            AlignedHeapChunk.cleanRememberedSetOfAlignedHeapChunk(aChunk);
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        trace.string("]").newline();
    }

    private void cleanRememberedSetUnalignedHeapChunk() {
        Log trace = Log.noopLog().string("[Space.cleanUnlignedHeapChunks:").string("  space: ").string(this.getName());
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            trace.newline().string("  uChunk: ").hex((WordBase)uChunk);
            UnalignedHeapChunk.cleanRememberedSetOfUnalignedHeapChunk(uChunk);
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        trace.string("]").newline();
    }

    void appendAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        Log trace;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Trying to append an aligned heap chunk but no mutual exclusion.");
        }
        if ((trace = Log.noopLog().string("[Space.appendAlignedHeapChunk:").newline()).isEnabled()) {
            trace.string("  before space: ").string(this.getName()).string("  first: ").hex((WordBase)this.getFirstAlignedHeapChunk()).string("  last: ").hex((WordBase)this.getLastAlignedHeapChunk()).newline();
            trace.string("  before chunk: ").hex((WordBase)aChunk).string("  .space: ").object(aChunk.getSpace());
            trace.string("  .previous: ").hex((WordBase)aChunk.getPrevious()).string("  .next: ").hex((WordBase)aChunk.getNext()).newline();
        }
        this.appendAlignedHeapChunkUninterruptibly(aChunk);
        this.getAccounting().noteAlignedHeapChunk(AlignedHeapChunk.committedObjectMemoryOfAlignedHeapChunk(aChunk));
        if (trace.isEnabled()) {
            trace.string("  after  space: ").string(this.getName()).string("  first: ").hex((WordBase)this.getFirstAlignedHeapChunk()).string("  last: ").hex((WordBase)this.getLastAlignedHeapChunk()).newline();
            trace.string("  after  chunk: ").hex((WordBase)aChunk).hex((WordBase)aChunk).string("  space: ").string(aChunk.getSpace().getName());
            trace.string("  .previous: ").hex((WordBase)aChunk.getPrevious()).string("  .next: ").hex((WordBase)aChunk.getNext()).newline();
            trace.string("]").newline();
        }
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void appendAlignedHeapChunkUninterruptibly(AlignedHeapChunk.AlignedHeader aChunk) {
        AlignedHeapChunk.AlignedHeader oldLast = this.getLastAlignedHeapChunk();
        aChunk.setSpace(this);
        aChunk.setPrevious(oldLast);
        aChunk.setNext((HeapChunk.Header)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            oldLast.setNext(aChunk);
        }
        this.setLastAlignedHeapChunk(aChunk);
        if (this.getFirstAlignedHeapChunk().isNull()) {
            this.setFirstAlignedHeapChunk(aChunk);
        }
    }

    void extractAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        assert (VMOperation.isGCInProgress()) : "Should only be called by the collector.";
        this.extractAlignedHeapChunkUninterruptibly(aChunk);
        this.getAccounting().unnoteAlignedHeapChunk(AlignedHeapChunk.committedObjectMemoryOfAlignedHeapChunk(aChunk));
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractAlignedHeapChunkUninterruptibly(AlignedHeapChunk.AlignedHeader aChunk) {
        AlignedHeapChunk.AlignedHeader chunkNext = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        AlignedHeapChunk.AlignedHeader chunkPrev = (AlignedHeapChunk.AlignedHeader)aChunk.getPrevious();
        if (chunkPrev.isNonNull()) {
            chunkPrev.setNext(chunkNext);
        } else {
            this.setFirstAlignedHeapChunk(chunkNext);
        }
        if (chunkNext.isNonNull()) {
            chunkNext.setPrevious(chunkPrev);
        } else {
            this.setLastAlignedHeapChunk(chunkPrev);
        }
        aChunk.setNext((HeapChunk.Header)WordFactory.nullPointer());
        aChunk.setPrevious((HeapChunk.Header)WordFactory.nullPointer());
        aChunk.setSpace(null);
    }

    private AlignedHeapChunk.AlignedHeader popAlignedHeapChunk() {
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        if (aChunk.isNonNull()) {
            this.extractAlignedHeapChunk(aChunk);
        }
        return aChunk;
    }

    void appendUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.guaranteeOwnsThreadMutex("Trying to append an unaligned chunk but no mutual exclusion.");
        }
        this.appendUnalignedHeapChunkUninterruptibly(uChunk);
        this.getAccounting().noteUnalignedHeapChunk(UnalignedHeapChunk.committedObjectMemoryOfUnalignedHeapChunk(uChunk));
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void appendUnalignedHeapChunkUninterruptibly(UnalignedHeapChunk.UnalignedHeader uChunk) {
        UnalignedHeapChunk.UnalignedHeader oldLast = this.getLastUnalignedHeapChunk();
        uChunk.setSpace(this);
        uChunk.setPrevious(oldLast);
        uChunk.setNext((HeapChunk.Header)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            oldLast.setNext(uChunk);
        }
        this.setLastUnalignedHeapChunk(uChunk);
        if (this.getFirstUnalignedHeapChunk().isNull()) {
            this.setFirstUnalignedHeapChunk(uChunk);
        }
    }

    void extractUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        assert (VMOperation.isGCInProgress()) : "Trying to extract an unaligned chunk but not in a VMOperation.";
        this.extractUnalignedHeapChunkUninterruptibly(uChunk);
        this.getAccounting().unnoteUnalignedHeapChunk(UnalignedHeapChunk.committedObjectMemoryOfUnalignedHeapChunk(uChunk));
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractUnalignedHeapChunkUninterruptibly(UnalignedHeapChunk.UnalignedHeader uChunk) {
        UnalignedHeapChunk.UnalignedHeader chunkNext = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        UnalignedHeapChunk.UnalignedHeader chunkPrev = (UnalignedHeapChunk.UnalignedHeader)uChunk.getPrevious();
        if (chunkPrev.isNonNull()) {
            chunkPrev.setNext(chunkNext);
        } else {
            this.setFirstUnalignedHeapChunk(chunkNext);
        }
        if (chunkNext.isNonNull()) {
            chunkNext.setPrevious(chunkPrev);
        } else {
            this.setLastUnalignedHeapChunk(chunkPrev);
        }
        uChunk.setNext((HeapChunk.Header)WordFactory.nullPointer());
        uChunk.setPrevious((HeapChunk.Header)WordFactory.nullPointer());
        uChunk.setSpace(null);
    }

    private UnalignedHeapChunk.UnalignedHeader popUnalignedHeapChunk() {
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        if (uChunk.isNonNull()) {
            this.extractUnalignedHeapChunk(uChunk);
        }
        return uChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader getFirstAlignedHeapChunk() {
        return this.firstAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setFirstAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        this.firstAlignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader getLastAlignedHeapChunk() {
        return this.lastAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setLastAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        this.lastAlignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnalignedHeapChunk.UnalignedHeader getFirstUnalignedHeapChunk() {
        return this.firstUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setFirstUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.firstUnalignedHeapChunk = chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnalignedHeapChunk.UnalignedHeader getLastUnalignedHeapChunk() {
        return this.lastUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void setLastUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.lastUnalignedHeapChunk = chunk;
    }

    private void releaseAlignedHeapChunks() {
        AlignedHeapChunk.AlignedHeader chunk = this.popAlignedHeapChunk();
        while (chunk.isNonNull()) {
            HeapChunkProvider.get().consumeAlignedChunk(chunk);
            chunk = this.popAlignedHeapChunk();
        }
        assert (this.getFirstAlignedHeapChunk().isNull()) : "Failed to remove first AlignedHeapChunk.";
        assert (this.getLastAlignedHeapChunk().isNull()) : "Failed to remove last AlignedHeapChunk.";
    }

    private void releaseUnalignedHeapChunks() {
        UnalignedHeapChunk.UnalignedHeader chunk = this.popUnalignedHeapChunk();
        while (chunk.isNonNull()) {
            HeapChunkProvider.get().consumeUnalignedChunk(chunk);
            chunk = this.popUnalignedHeapChunk();
        }
        assert (this.getFirstUnalignedHeapChunk().isNull()) : "Failed to remove first UnalignedHeapChunk";
        assert (this.getLastUnalignedHeapChunk().isNull()) : "Failed to remove last UnalignedHeapChunk";
    }

    Object promoteAlignedObject(Object original, Space originalSpace) {
        assert (ObjectHeaderImpl.isAlignedObject(original));
        assert (this != originalSpace && originalSpace.isFrom());
        if (HeapOptions.TraceObjectPromotion.getValue().booleanValue()) {
            Log.log().string("[promoteAlignedObject:").string("  obj: ").object(original).string("  fromSpace: ").string(originalSpace.getName()).string("  toSpace: ").string(this.getName()).string("  size: ").unsigned((WordBase)LayoutEncoding.getSizeFromObject(original)).string("]").newline();
        }
        Object copy = this.copyAlignedObject(original);
        ObjectHeaderImpl.installForwardingPointer(original, copy);
        return copy;
    }

    private Object copyAlignedObject(Object originalObj) {
        assert (VMOperation.isGCInProgress());
        assert (ObjectHeaderImpl.isAlignedObject(originalObj));
        UnsignedWord size = LayoutEncoding.getSizeFromObject(originalObj);
        Pointer copyMemory = this.allocateMemory(size);
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)copyMemory.isNull())) {
            Log failureLog = Log.log().string("[! Space.copyAlignedObject:").indent(true);
            failureLog.string("  failure to allocate ").unsigned((WordBase)size).string(" bytes").newline();
            failureLog.string("  object to be promoted: ").object(originalObj).string(" header ").hex((WordBase)ObjectHeaderImpl.readHeaderFromObject(originalObj)).newline();
            failureLog.string(" !]").indent(false);
            throw VMError.shouldNotReachHere("Promotion failure");
        }
        Word originalMemory = Word.objectToUntrackedPointer((Object)originalObj);
        UnsignedWord offset = (UnsignedWord)WordFactory.zero();
        while (BranchProbabilityNode.probability((double)0.9, (boolean)offset.belowThan(size))) {
            copyMemory.writeWord((WordBase)offset, originalMemory.readWord((WordBase)offset));
            offset = offset.add(ConfigurationValues.getTarget().wordSize);
        }
        Object copy = copyMemory.toObject();
        AlignedHeapChunk.AlignedHeader copyChunk = AlignedHeapChunk.getEnclosingAlignedHeapChunk(copy);
        if (copyChunk.getSpace().isOldSpace()) {
            AlignedHeapChunk.setUpRememberedSetForObjectOfAlignedHeapChunk(copyChunk, copy);
        }
        return copy;
    }

    private void promoteAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk, Space originalSpace) {
        assert (this != originalSpace && originalSpace.isFrom());
        if (HeapOptions.TraceObjectPromotion.getValue().booleanValue()) {
            Log.log().string("[promoteAlignedHeapChunk:").string("  chunk: ").hex((WordBase)chunk).string("  fromSpace: ").string(originalSpace.getName()).string("  toSpace: ").string(this.getName()).string("]").newline();
        }
        originalSpace.extractAlignedHeapChunk(chunk);
        this.appendAlignedHeapChunk(chunk);
        if (this.isOldSpace() && originalSpace.isYoungSpace()) {
            AlignedHeapChunk.constructRememberedSetOfAlignedHeapChunk(chunk);
        }
    }

    void promoteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk, Space originalSpace) {
        assert (this != originalSpace && originalSpace.isFrom());
        if (HeapOptions.TraceObjectPromotion.getValue().booleanValue()) {
            Log.log().string("[promoteUnalignedHeapChunk:").string("  chunk: ").hex((WordBase)chunk).string("  fromSpace: ").string(originalSpace.getName()).string("  toSpace: ").string(this.getName()).string("]").newline();
        }
        originalSpace.extractUnalignedHeapChunk(chunk);
        this.appendUnalignedHeapChunk(chunk);
        if (this.isOldSpace()) {
            UnalignedHeapChunk.setUpRememberedSetOfUnalignedHeapChunk(chunk);
        }
    }

    private AlignedHeapChunk.AlignedHeader requestAlignedHeapChunk() {
        assert (VMOperation.isGCInProgress()) : "Should only be called from the collector.";
        Log trace = Log.noopLog().string("[Space.requestAlignedHeapChunk:").string("  space: ").string(this.getName()).newline();
        AlignedHeapChunk.AlignedHeader aChunk = HeapChunkProvider.get().produceAlignedChunk();
        trace.string("  aChunk: ").hex((WordBase)aChunk);
        if (aChunk.isNonNull()) {
            this.appendAlignedHeapChunk(aChunk);
        }
        trace.string("  Space.requestAlignedHeapChunk returns: ").hex((WordBase)aChunk).string("]").newline();
        return aChunk;
    }

    void absorb(Space src) {
        AlignedHeapChunk.AlignedHeader aChunk = src.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
            src.extractAlignedHeapChunk(aChunk);
            this.appendAlignedHeapChunk(aChunk);
            aChunk = next;
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = src.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
            src.extractUnalignedHeapChunk(uChunk);
            this.appendUnalignedHeapChunk(uChunk);
            uChunk = next;
        }
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        boolean continueVisiting = true;
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (continueVisiting && aChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(aChunk, AlignedHeapChunk.getMemoryWalkerAccess());
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (continueVisiting && uChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(uChunk, UnalignedHeapChunk.getMemoryWalkerAccess());
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        return continueVisiting;
    }

    UnsignedWord getChunkBytes() {
        return this.getAlignedChunkBytes().add(this.getUnalignedChunkBytes());
    }

    private UnsignedWord getAlignedChunkBytes() {
        UnsignedWord alignedChunkCount = WordFactory.unsigned((long)this.getAccounting().getAlignedChunkCount());
        return HeapPolicy.getAlignedHeapChunkSize().multiply(alignedChunkCount);
    }

    private UnsignedWord getUnalignedChunkBytes() {
        UnsignedWord unalignedChunkCount = WordFactory.unsigned((long)this.getAccounting().getUnalignedChunkCount());
        UnsignedWord unalignedChunkOverhead = UnalignedHeapChunk.getUnalignedHeapOverhead();
        return this.getAccounting().getUnalignedChunkBytes().add(unalignedChunkCount.multiply(unalignedChunkOverhead));
    }

    UnsignedWord getObjectBytes() {
        return this.getAlignedObjectBytes().add(this.getUnalignedObjectBytes());
    }

    private UnsignedWord getAlignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            Pointer allocatedBytes = aChunk.getTop().subtract((UnsignedWord)AlignedHeapChunk.getObjectsStart(aChunk));
            result = result.add((UnsignedWord)allocatedBytes);
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        return result;
    }

    private UnsignedWord getUnalignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            Pointer allocatedBytes = uChunk.getTop().subtract((UnsignedWord)UnalignedHeapChunk.getObjectStart(uChunk));
            result = result.add((UnsignedWord)allocatedBytes);
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        return result;
    }

    public void verifyDirtyCards() {
        AlignedHeapChunk.AlignedHeader aChunk = this.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            if (!CardTable.verify(AlignedHeapChunk.getCardTableStart(aChunk), AlignedHeapChunk.getFirstObjectTableStart(aChunk), AlignedHeapChunk.getAlignedHeapChunkStart(aChunk), aChunk.getTop())) {
                Log.log().string("AlignedChunk card verification failed!").newline();
                Log.log().flush();
            }
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
    }

    public static interface Verifier {
        public Verifier initialize(Space var1);

        public boolean verify();
    }

    public static class Accounting {
        private long alignedCount;
        private UnsignedWord alignedChunkBytes;
        private long unalignedCount;
        private UnsignedWord unalignedChunkBytes;
        private static final Log log = Log.noopLog();

        public static Accounting factory() {
            return new Accounting();
        }

        long getAlignedChunkCount() {
            return this.alignedCount;
        }

        UnsignedWord getAlignedChunkBytes() {
            return this.alignedChunkBytes;
        }

        long getUnalignedChunkCount() {
            return this.unalignedCount;
        }

        UnsignedWord getUnalignedChunkBytes() {
            return this.unalignedChunkBytes;
        }

        public void report(Log reportLog) {
            reportLog.string("aligned: ").unsigned((WordBase)this.alignedChunkBytes).string("/").unsigned(this.alignedCount);
            reportLog.string(" ");
            reportLog.string("unaligned: ").unsigned((WordBase)this.unalignedChunkBytes).string("/").unsigned(this.unalignedCount);
        }

        void noteAlignedHeapChunk(UnsignedWord size) {
            log.string("[Space.Accounting.NoteAlignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
            ++this.alignedCount;
            this.alignedChunkBytes = this.alignedChunkBytes.add(size);
            log.string("  alignedCount: ").unsigned(this.alignedCount).string("  alignedChunkBytes: ").unsigned((WordBase)this.alignedChunkBytes).string("]").newline();
        }

        void unnoteAlignedHeapChunk(UnsignedWord size) {
            log.string("[Space.Accounting.unnoteAlignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
            --this.alignedCount;
            this.alignedChunkBytes = this.alignedChunkBytes.subtract(size);
            log.string("  alignedCount: ").unsigned(this.alignedCount).string("  alignedChunkBytes: ").unsigned((WordBase)this.alignedChunkBytes).string("]").newline();
        }

        void noteUnalignedHeapChunk(UnsignedWord size) {
            log.string("[Space.Accounting.NoteUnalignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
            ++this.unalignedCount;
            this.unalignedChunkBytes = this.unalignedChunkBytes.add(size);
            log.string("  unalignedCount: ").unsigned(this.unalignedCount).string("  unalignedChunkBytes: ").unsigned((WordBase)this.unalignedChunkBytes).newline();
        }

        void unnoteUnalignedHeapChunk(UnsignedWord size) {
            log.string("Space.Accounting.unnoteUnalignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
            --this.unalignedCount;
            this.unalignedChunkBytes = this.unalignedChunkBytes.subtract(size);
            log.string("  unalignedCount: ").unsigned(this.unalignedCount).string("  unalignedChunkBytes: ").unsigned((WordBase)this.unalignedChunkBytes).string("]").newline();
        }

        public void reset() {
            this.alignedCount = 0L;
            this.alignedChunkBytes = (UnsignedWord)WordFactory.zero();
            this.unalignedCount = 0L;
            this.unalignedChunkBytes = (UnsignedWord)WordFactory.zero();
        }

        Accounting() {
            this.reset();
        }
    }
}

