/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

class RuntimeCodeCacheReachabilityAnalyzer
implements ObjectReferenceVisitor {
    private boolean unreachableObjects;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheReachabilityAnalyzer() {
    }

    public void initialize() {
        this.unreachableObjects = false;
    }

    public boolean hasUnreachableObjects() {
        return this.unreachableObjects;
    }

    @Override
    public boolean visitObjectReference(Pointer ptrPtrToObject, boolean compressed) {
        assert (!this.unreachableObjects);
        Word ptrToObj = ReferenceAccess.singleton().readObjectAsUntrackedPointer(ptrPtrToObject, compressed);
        if (ptrToObj.isNonNull() && !RuntimeCodeCacheReachabilityAnalyzer.isReachable((Pointer)ptrToObj)) {
            this.unreachableObjects = true;
            return false;
        }
        return true;
    }

    public static boolean isReachable(Pointer ptrToObj) {
        assert (ptrToObj.isNonNull());
        if (HeapImpl.getHeapImpl().isInImageHeap(ptrToObj)) {
            return true;
        }
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(ptrToObj);
        if (ObjectHeaderImpl.isForwardedHeader(header)) {
            return true;
        }
        Space space = HeapChunk.getEnclosingHeapChunk(ptrToObj, header).getSpace();
        if (!space.isFrom()) {
            return true;
        }
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        Class<?> clazz = DynamicHub.toClass(ohi.dynamicHubFromObjectHeader(header));
        return RuntimeCodeCacheReachabilityAnalyzer.isWhitelistedClass(clazz);
    }

    private static boolean isWhitelistedClass(Class<?> clazz) {
        return SpeculationLog.SpeculationReason.class.isAssignableFrom(clazz) || SharedRuntimeMethod.class.isAssignableFrom(clazz);
    }
}

