/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import org.graalvm.compiler.options.Option;

public class HeapPolicyOptions {
    @Option(help={"The maximum heap size as percent of physical memory"})
    public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new RuntimeOptionKey<Integer>(80);
    @Option(help={"The maximum size of the young generation as a percent of the maximum heap size"})
    public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new RuntimeOptionKey<Integer>(10);
    @Option(help={"Bytes that can be allocated before asking what the physical memory size is"})
    public static final HostedOptionKey<Long> AllocationBeforePhysicalMemorySize = new HostedOptionKey<Long>(0x100000L);
    @Option(help={"The size of an aligned chunk."})
    public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(0x100000L);
    @Option(help={"How many bytes is enough to allocate an unaligned chunk for an array?  0 implies (AlignedHeapChunkSize / 8)."})
    public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(0L);
    @Option(help={"Zap memory chunks"})
    public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false);
    @Option(help={"Zap produced memory chunks"})
    public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false);
    @Option(help={"Zap consumed memory chunks"})
    public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false);
    @Option(help={"Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape."})
    public static final RuntimeOptionKey<Boolean> TraceHeapChunks = new RuntimeOptionKey<Boolean>(false);
    @Option(help={"Policy used when users request garbage collection."})
    public static final HostedOptionKey<String> UserRequestedGCPolicy = new HostedOptionKey<String>(HeapPolicy.AlwaysCollectCompletely.class.getName());
    @Option(help={"Defines the upper bound for the number of remaining bytes in the young generation that cause a collection when `System.gc` is called."})
    public static final RuntimeOptionKey<Long> UserRequestedGCThreshold = new RuntimeOptionKey<Long>(0x1000000L);
    @Option(help={"Maximum value for survivor space"})
    public static final HostedOptionKey<Integer> MaxSurvivorSpaces = new HostedOptionKey<Integer>(0);
}

