/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.function.IntUnaryOperator;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapChunk {
    @NeverInline(value="Not performance critical")
    public static boolean walkObjectsFrom(Header<?> that, Pointer offset, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFromInline(that, offset, visitor);
    }

    @AlwaysInline(value="GC performance")
    public static boolean walkObjectsFromInline(Header<?> that, Pointer startOffset, ObjectVisitor visitor) {
        Pointer offset = startOffset;
        while (offset.belowThan((UnsignedWord)that.getTop())) {
            Object obj = offset.toObject();
            if (!visitor.visitObjectInline(obj)) {
                return false;
            }
            offset = offset.add(LayoutEncoding.getSizeFromObject(obj));
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord availableObjectMemory(Header<?> that) {
        Pointer top = that.getTop();
        Pointer end = that.getEnd();
        return end.subtract((UnsignedWord)top);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static void setTopCarefully(Header<?> that, Pointer newTop) {
        assert (that.getTop().belowOrEqual((UnsignedWord)newTop)) : "newTop too low.";
        assert (newTop.belowOrEqual((UnsignedWord)that.getEnd())) : "newTop too high.";
        that.setTop(newTop);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static Pointer asPointer(Header<?> that) {
        return (Pointer)that;
    }

    public static Header<?> getEnclosingHeapChunk(Object obj) {
        assert (!HeapImpl.getHeapImpl().isInImageHeap(obj)) : "Must be checked before calling this method";
        assert (!ObjectHeaderImpl.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)obj))) : "Forwarded objects must be a pointer and not an object";
        if (ObjectHeaderImpl.isAlignedObject(obj)) {
            return AlignedHeapChunk.getEnclosingAlignedHeapChunk(obj);
        }
        assert (ObjectHeaderImpl.isUnalignedObject(obj));
        return UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(obj);
    }

    public static Header<?> getEnclosingHeapChunk(Pointer ptrToObj, UnsignedWord header) {
        if (ObjectHeaderImpl.isAlignedHeader(ptrToObj, header)) {
            return AlignedHeapChunk.getEnclosingAlignedHeapChunkFromPointer(ptrToObj);
        }
        return UnalignedHeapChunk.getEnclosingUnalignedHeapChunkFromPointer(ptrToObj);
    }

    static boolean verifyHeapChunk(Header<?> that, Pointer start) {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[HeapChunk.verify:");
        trace.string("  that:  ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)that.getTop()).string("  end: ").hex((WordBase)that.getEnd());
        Pointer p = start;
        while (p.belowThan((UnsignedWord)that.getTop())) {
            if (!HeapImpl.getHeapImpl().getHeapVerifierImpl().verifyObjectAt(p)) {
                Log witness = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[HeapChunk.verify:");
                witness.string("  that:  ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)that.getTop()).string("  end: ").hex((WordBase)that.getEnd());
                witness.string("  space: ").string(that.getSpace().getName());
                witness.string("  object at p: ").hex((WordBase)p).string("  fails to verify").string("]").newline();
                trace.string("  returns false]").newline();
                return false;
            }
            UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointerCarefully(p);
            Object o = ObjectHeaderImpl.isForwardedHeaderCarefully(header) ? ObjectHeaderImpl.getForwardedObject(p) : p.toObject();
            p = p.add(LayoutEncoding.getSizeFromObject(o));
        }
        trace.string("  returns true]").newline();
        return true;
    }

    public static abstract class MemoryWalkerAccessImpl<T extends Header<?>>
    implements MemoryWalker.HeapChunkAccess<T> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected MemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(T heapChunk) {
            return (UnsignedWord)heapChunk;
        }

        @Override
        public UnsignedWord getSize(T heapChunk) {
            return heapChunk.getEnd().subtract(this.getStart(heapChunk));
        }

        @Override
        public UnsignedWord getAllocationEnd(T heapChunk) {
            return heapChunk.getTop();
        }

        @Override
        public String getRegion(T heapChunk) {
            Space space = heapChunk.getSpace();
            String result = space == null ? "free" : (space.isYoungSpace() ? "young" : "old");
            return result;
        }
    }

    @RawStructure
    public static interface Header<T extends Header<T>>
    extends HeaderPadding {
        @RawField
        @UniqueLocationIdentity
        public Pointer getTop();

        @RawField
        @UniqueLocationIdentity
        public void setTop(Pointer var1);

        @RawField
        @UniqueLocationIdentity
        public Pointer getEnd();

        @RawField
        @UniqueLocationIdentity
        public void setEnd(Pointer var1);

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public Space getSpace();

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public void setSpace(Space var1);

        @RawField
        @UniqueLocationIdentity
        public T getPrevious();

        @RawField
        @UniqueLocationIdentity
        public void setPrevious(T var1);

        @RawField
        @UniqueLocationIdentity
        public T getNext();

        @RawField
        @UniqueLocationIdentity
        public void setNext(T var1);
    }

    @RawStructure(sizeProvider=HeaderPaddingSizeProvider.class)
    private static interface HeaderPadding
    extends PointerBase {
    }

    static class HeaderPaddingSizeProvider
    implements IntUnaryOperator {
        HeaderPaddingSizeProvider() {
        }

        @Override
        public int applyAsInt(int operand) {
            assert (operand == 0) : "padding structure does not declare any fields";
            return Options.HeapChunkHeaderPadding.getValue();
        }
    }

    static class Options {
        @Option(help={"Number of bytes at the beginning of each heap chunk that are not used for payload data, i.e., can be freely used as metadata by the heap chunk provider."})
        public static final HostedOptionKey<Integer> HeapChunkHeaderPadding = new HostedOptionKey<Integer>(0);

        Options() {
        }
    }
}

