/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.libc;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MuslLibc
implements LibCBase {
    private Path specFilePath;
    private static final String GCC_MUSL_TEMPLATE_PATH = "specs/gcc-musl-specs.input";
    private static final String GCC_MUSL_SPEC_PATH = "gcc-musl.specs";
    private static final String PATH_PLACEHOLDER = "__BASE_PATH__";

    @Override
    public String getJDKStaticLibsPath() {
        return "musl";
    }

    @Override
    public void prepare(Path directory) {
        if (!SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
            String useMuslCFlag = SubstrateOptionsParser.commandArgument(SubstrateOptions.UseMuslC, "+");
            String staticExecutableFlag = SubstrateOptionsParser.commandArgument(SubstrateOptions.StaticExecutable, "+");
            UserError.abort(useMuslCFlag + " can only be used when producing a static executable. Please add " + staticExecutableFlag + " to the command line arguments, or remove " + useMuslCFlag + ".", new Object[0]);
        }
        this.setUpSpecFile(directory);
    }

    @Override
    public List<String> getAdditionalQueryCodeCompilerOptions() {
        return Collections.singletonList("--static");
    }

    @Override
    public List<String> getCCompilerOptions() {
        return Arrays.asList("-specs", this.getSpecFilePath().toString());
    }

    public void setUpSpecFile(Path directory) {
        VMError.guarantee(this.specFilePath == null);
        this.specFilePath = directory.resolve(GCC_MUSL_SPEC_PATH);
        InputStream stream = MuslLibc.class.getResourceAsStream(GCC_MUSL_TEMPLATE_PATH);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String content = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        String muslPath = Paths.get(SubstrateOptions.UseMuslC.getValue(), new String[0]).toAbsolutePath().toString();
        content = content.replaceAll(PATH_PLACEHOLDER, muslPath);
        try {
            Files.write(this.specFilePath, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            UserError.abort("Unable to write the specs file to the temporary directory " + directory.toAbsolutePath().toString() + ". Please check if you have write access in the directory.", new Object[0]);
        }
    }

    public Path getSpecFilePath() {
        VMError.guarantee(this.specFilePath != null);
        return this.specFilePath.toAbsolutePath();
    }

    @Override
    public boolean hasIsolatedNamespaces() {
        return false;
    }
}

