/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.DumpAllStacks;
import com.oracle.svm.core.DumpHeapReport;
import com.oracle.svm.core.DumpRuntimeCompilation;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class VMInspection
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspection.isEnabled();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(() -> {
            DumpAllStacks.install();
            if (!Platform.includedIn(Platform.WINDOWS.class)) {
                DumpHeapReport.install();
                if (DeoptimizationSupport.enabled()) {
                    DumpRuntimeCompilation.install();
                }
            }
        });
    }

    @Fold
    public static boolean isEnabled() {
        return VMInspectionOptions.AllowVMInspection.getValue();
    }
}

