/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.truffle.nfi.ErrnoMirror;
import com.oracle.svm.truffle.nfi.LibFFI;
import com.oracle.svm.truffle.nfi.LocalNativeScope;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeClosure;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIContext;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.truffle.api.CompilerDirectives;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class TruffleNFISupport {
    static final Charset UTF8 = Charset.forName("utf8");
    private static final FastThreadLocalObject<LocalNativeScope> currentScope = FastThreadLocalFactory.createObject(LocalNativeScope.class);
    private final ObjectHandles globalHandles;
    private final ObjectHandles closureHandles;
    private final ObjectHandles contextHandles;
    public final String errnoGetterFunctionName;

    protected TruffleNFISupport(String errnoLocation) {
        this.errnoGetterFunctionName = errnoLocation;
        this.globalHandles = ObjectHandles.create();
        this.closureHandles = ObjectHandles.create();
        this.contextHandles = ObjectHandles.create();
    }

    public static LocalNativeScope createLocalScope(int pinCount) {
        LocalNativeScope parent = currentScope.get();
        LocalNativeScope ret = new LocalNativeScope(parent, pinCount);
        currentScope.set(ret);
        return ret;
    }

    public static void closeLocalScope(LocalNativeScope current, LocalNativeScope parent) {
        assert (currentScope.get() == current);
        currentScope.set(parent);
    }

    public static TruffleObjectHandle createLocalHandle(Object obj) {
        return currentScope.get().createLocalHandle(obj);
    }

    public TruffleObjectHandle createGlobalHandle(Object obj) {
        return (TruffleObjectHandle)this.globalHandles.create(obj);
    }

    public void destroyGlobalHandle(TruffleObjectHandle handle) {
        SignedWord word = (SignedWord)handle;
        if (word.greaterThan(0)) {
            this.globalHandles.destroy((ObjectHandle)word);
        }
    }

    public Object resolveHandle(TruffleObjectHandle handle) {
        SignedWord word = (SignedWord)handle;
        if (word.equal(0)) {
            return null;
        }
        if (word.greaterThan(0)) {
            return this.globalHandles.get((ObjectHandle)word);
        }
        return currentScope.get().resolveLocalHandle(handle);
    }

    public LibFFI.NativeClosureHandle createClosureHandle(NativeClosure closure) {
        return (LibFFI.NativeClosureHandle)this.closureHandles.create((Object)closure);
    }

    public NativeClosure resolveClosureHandle(LibFFI.NativeClosureHandle handle) {
        return (NativeClosure)this.closureHandles.get((ObjectHandle)handle);
    }

    public void destroyClosureHandle(LibFFI.NativeClosureHandle handle) {
        this.closureHandles.destroy((ObjectHandle)handle);
    }

    public NativeAPI.TruffleContextHandle createContextHandle(Target_com_oracle_truffle_nfi_impl_NFIContext context) {
        return (NativeAPI.TruffleContextHandle)this.contextHandles.create((Object)context);
    }

    public Target_com_oracle_truffle_nfi_impl_NFIContext resolveContextHandle(NativeAPI.TruffleContextHandle handle) {
        return (Target_com_oracle_truffle_nfi_impl_NFIContext)this.contextHandles.get((ObjectHandle)handle);
    }

    public void destroyContextHandle(NativeAPI.TruffleContextHandle handle) {
        this.contextHandles.destroy((ObjectHandle)handle);
    }

    @CompilerDirectives.TruffleBoundary
    public static String utf8ToJavaString(CCharPointer str) {
        if (str.equal((ComparableWord)WordFactory.zero())) {
            return null;
        }
        UnsignedWord len = SubstrateUtil.strlen(str);
        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)str, (int)((int)len.rawValue()));
        return UTF8.decode(buffer).toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] javaStringToUtf8(String str) {
        CharBuffer input = CharBuffer.wrap(new ZeroTerminatedCharSequence(str));
        return UTF8.encode(input).array();
    }

    protected abstract CCharPointer strdupImpl(CCharPointer var1);

    protected abstract long loadLibraryImpl(long var1, String var3, int var4);

    protected abstract void freeLibraryImpl(long var1);

    protected abstract long lookupImpl(long var1, long var3, String var5);

    public static CCharPointer strdup(CCharPointer src) {
        TruffleNFISupport truffleNFISupport = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        return truffleNFISupport.strdupImpl(src);
    }

    public static long loadLibrary(long nativeContext, String name, int flags) {
        TruffleNFISupport truffleNFISupport = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        return truffleNFISupport.loadLibraryImpl(nativeContext, name, flags);
    }

    public static void freeLibrary(long library) {
        TruffleNFISupport truffleNFISupport = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        truffleNFISupport.freeLibraryImpl(library);
    }

    public static long lookup(long nativeContext, long library, String name) {
        TruffleNFISupport truffleNFISupport = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        return truffleNFISupport.lookupImpl(nativeContext, library, name);
    }

    public static class NativeErrnoContext
    implements AutoCloseable {
        private final CIntPointer errnoMirror = ErrnoMirror.getErrnoMirrorLocation();

        public NativeErrnoContext() {
            CErrorNumber.setCErrorNumber(this.errnoMirror.read());
        }

        @Override
        public void close() {
            this.errnoMirror.write(CErrorNumber.getCErrorNumber());
        }
    }

    public static class ErrnoMirrorContext
    implements AutoCloseable {
        private final CIntPointer errnoMirror = ErrnoMirror.getErrnoMirrorLocation();

        public ErrnoMirrorContext() {
            this.errnoMirror.write(CErrorNumber.getCErrorNumber());
        }

        @Override
        public void close() {
            CErrorNumber.setCErrorNumber(this.errnoMirror.read());
        }
    }

    private static final class ZeroTerminatedCharSequence
    implements CharSequence {
        private CharSequence seq;

        ZeroTerminatedCharSequence(CharSequence seq) {
            this.seq = seq;
        }

        @Override
        public int length() {
            return this.seq.length() + 1;
        }

        @Override
        public char charAt(int index) {
            if (index == this.seq.length()) {
                return '\u0000';
            }
            return this.seq.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end == this.length()) {
                return new ZeroTerminatedCharSequence(this.seq.subSequence(start, end - 1));
            }
            return this.seq.subSequence(start, end);
        }
    }
}

