/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.truffle.SubstrateTruffleCompilationIdentifier;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import java.io.PrintStream;
import java.util.Map;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateTruffleCompilerImpl
extends TruffleCompilerImpl
implements SubstrateTruffleCompiler {
    private final String compilerConfigurationName = GraalConfiguration.instance().getCompilerConfigurationName();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompilerImpl(TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, Suites suites, LIRSuites lirSuites, Backend backend, Suites firstTierSuites, LIRSuites firstTierLIRSuites, Providers firstTierProviders, SnippetReflectionProvider snippetReflection) {
        super(runtime, plugins, suites, lirSuites, backend, firstTierSuites, firstTierLIRSuites, firstTierProviders, snippetReflection);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PartialEvaluator createPartialEvaluator() {
        return TruffleFeature.getSupport().createPartialEvaluator(this.lastTierProviders, this.config, this.snippetReflection, this.backend.getTarget().arch);
    }

    public void initialize() {
        super.initialize();
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(this.getBackend());
    }

    public PhaseSuite<HighTierContext> createGraphBuilderSuite() {
        return null;
    }

    public String getCompilerConfigurationName() {
        return this.compilerConfigurationName;
    }

    protected CompilationResult createCompilationResult(String name, CompilationIdentifier compilationIdentifier, CompilableTruffleAST compilable) {
        return new SubstrateCompilationResult(compilationIdentifier, name);
    }

    public TruffleCompilationIdentifier createCompilationIdentifier(CompilableTruffleAST optimizedCallTarget) {
        return new SubstrateTruffleCompilationIdentifier((OptimizedCallTarget)optimizedCallTarget);
    }

    public DebugContext createDebugContext(OptionValues options, CompilationIdentifier compilationId, CompilableTruffleAST callTarget, PrintStream logStream) {
        return GraalSupport.get().openDebugContext(options, compilationId, callTarget, logStream);
    }

    protected DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return GraalSupport.get().getDebugOutputDirectory();
    }

    protected Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return GraalSupport.get().getCompilationProblemsPerAction();
    }

    protected InstalledCode createInstalledCode(CompilableTruffleAST compilable) {
        return ((SubstrateCompilableTruffleAST)compilable).createInstalledCode();
    }
}

