/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;

public class HostedUniverse
implements Universe {
    protected final Inflation bb;
    protected final Map<AnalysisType, HostedType> types = new HashMap<AnalysisType, HostedType>();
    protected final Map<AnalysisField, HostedField> fields = new HashMap<AnalysisField, HostedField>();
    protected final Map<AnalysisMethod, HostedMethod> methods = new HashMap<AnalysisMethod, HostedMethod>();
    protected final Map<Signature, WrappedSignature> signatures = new HashMap<Signature, WrappedSignature>();
    protected final Map<ConstantPool, WrappedConstantPool> constantPools = new HashMap<ConstantPool, WrappedConstantPool>();
    private volatile ConcurrentHashMap<AnalysisMethod, Boolean> methodsWithStackValues = new ConcurrentHashMap();
    protected EnumMap<JavaKind, HostedType> kindToType = new EnumMap(JavaKind.class);
    protected List<HostedType> orderedTypes;
    protected List<HostedMethod> orderedMethods;
    protected List<HostedField> orderedFields;
    protected int numInterfaceBits;

    public HostedUniverse(Inflation bb) {
        this.bb = bb;
    }

    public HostedType getType(JavaKind kind) {
        assert (this.kindToType.containsKey(kind));
        return this.kindToType.get(kind);
    }

    public HostedInstanceClass getObjectClass() {
        HostedInstanceClass result = (HostedInstanceClass)this.kindToType.get(JavaKind.Object);
        assert (result != null);
        return result;
    }

    public synchronized HostedMethod createDeoptTarget(HostedMethod method) {
        if (method.compilationInfo.getDeoptTargetMethod() == null) {
            HostedMethod deoptTarget = new HostedMethod(this, method.getWrapped(), method.getDeclaringClass(), method.getSignature(), method.getConstantPool(), method.getExceptionHandlers());
            assert (method.staticAnalysisResults != null);
            deoptTarget.staticAnalysisResults = method.staticAnalysisResults;
            method.compilationInfo.setDeoptTarget(deoptTarget);
        }
        return method.compilationInfo.getDeoptTargetMethod();
    }

    public boolean contains(JavaType type) {
        return this.types.containsKey(type);
    }

    public SVMHost hostVM() {
        return this.bb.getHostVM();
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.bb.getProviders().getSnippetReflection();
    }

    public HostedType lookup(JavaType type) {
        JavaType result = this.lookupAllowUnresolved(type);
        if (result instanceof ResolvedJavaType) {
            return (HostedType)result;
        }
        throw new UnsupportedFeatureException("Unresolved type found. Probably there are some compilation or classpath problems. " + type.toJavaName(true));
    }

    public JavaType lookupAllowUnresolved(JavaType type) {
        if (!(type instanceof ResolvedJavaType)) {
            return type;
        }
        assert (this.types.containsKey(type)) : type;
        return this.optionalLookup(type);
    }

    public HostedType optionalLookup(JavaType type) {
        return this.types.get(type);
    }

    public HostedField lookup(JavaField field) {
        JavaField result = this.lookupAllowUnresolved(field);
        if (result instanceof ResolvedJavaField) {
            return (HostedField)result;
        }
        throw new UnsupportedFeatureException("Unresolved field found. Probably there are some compilation or classpath problems. " + field.format("%H.%n"));
    }

    public JavaField lookupAllowUnresolved(JavaField field) {
        if (!(field instanceof ResolvedJavaField)) {
            return field;
        }
        assert (this.fields.containsKey(field)) : field;
        return this.optionalLookup(field);
    }

    public HostedField optionalLookup(JavaField field) {
        return this.fields.get(field);
    }

    public HostedMethod lookup(JavaMethod method) {
        JavaMethod result = this.lookupAllowUnresolved(method);
        if (result instanceof ResolvedJavaMethod) {
            return (HostedMethod)result;
        }
        throw new UnsupportedFeatureException("Unresolved method found. Probably there are some compilation or classpath problems. " + method.format("%H.%n(%p)"));
    }

    public JavaMethod lookupAllowUnresolved(JavaMethod method) {
        if (!(method instanceof ResolvedJavaMethod)) {
            return method;
        }
        assert (this.methods.containsKey(method)) : method;
        return this.optionalLookup(method);
    }

    public HostedMethod optionalLookup(JavaMethod method) {
        return this.methods.get(method);
    }

    public HostedMethod[] lookup(JavaMethod[] inputs) {
        HostedMethod[] result = new HostedMethod[inputs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.lookup(inputs[i]);
        }
        return result;
    }

    public WrappedSignature lookup(Signature signature, WrappedJavaType defaultAccessingClass) {
        assert (this.signatures.containsKey(signature)) : signature;
        return this.signatures.get(signature);
    }

    public WrappedConstantPool lookup(ConstantPool constantPool, WrappedJavaType defaultAccessingClass) {
        assert (this.constantPools.containsKey(constantPool)) : constantPool;
        return this.constantPools.get(constantPool);
    }

    public JavaConstant lookup(JavaConstant constant) {
        return constant;
    }

    public Collection<HostedType> getTypes() {
        return this.orderedTypes;
    }

    public Collection<HostedField> getFields() {
        return this.orderedFields;
    }

    public Collection<HostedMethod> getMethods() {
        return this.orderedMethods;
    }

    public BigBang getBigBang() {
        return this.bb;
    }

    public ConstantReflectionProvider getConstantReflectionProvider() {
        return this.bb.getConstantReflectionProvider();
    }

    public ConstantFieldProvider getConstantFieldProvider() {
        return this.bb.getConstantFieldProvider();
    }

    public void recordMethodWithStackValues(AnalysisMethod analysisMethod) {
        this.methodsWithStackValues.put(analysisMethod, Boolean.TRUE);
    }

    public Collection<AnalysisMethod> getMethodsWithStackValues() {
        return Collections.unmodifiableCollection(this.methodsWithStackValues.keySet());
    }

    public ResolvedJavaMethod resolveSubstitution(ResolvedJavaMethod method) {
        return method;
    }

    public HostedType objectType() {
        return this.types.get(this.bb.getUniverse().objectType());
    }
}

