/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.image.CCLinkerInvocation;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.impl.InternalPlatform;

public abstract class NativeBootImageViaCC
extends NativeBootImage {
    public NativeBootImageViaCC(AbstractBootImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, imageClassLoader);
    }

    public AbstractBootImage.NativeImageKind getOutputKind() {
        return this.kind;
    }

    private static boolean removeUnusedSymbols() {
        if (SubstrateOptions.RemoveUnusedSymbols.hasBeenSet()) {
            return SubstrateOptions.RemoveUnusedSymbols.getValue();
        }
        return Platform.includedIn(Platform.LINUX.class);
    }

    LinkerInvocation getLinkerInvocation(Path outputDirectory, Path tempDirectory, String imageName) {
        CCLinkerInvocation inv;
        switch (ObjectFile.getNativeFormat()) {
            case MACH_O: {
                inv = new DarwinCCLinkerInvocation();
                break;
            }
            case PECOFF: {
                inv = new WindowsCCLinkerInvocation();
                break;
            }
            default: {
                inv = new BinutilsCCLinkerInvocation();
            }
        }
        Path outputFile = outputDirectory.resolve(imageName + this.getBootImageKind().getFilenameSuffix());
        UserError.guarantee(!Files.isDirectory(outputFile, new LinkOption[0]), "Cannot write image to %s. Path exists as directory. (Use -H:Name=<image name>)", outputFile);
        inv.setOutputFile(outputFile);
        inv.setOutputKind(this.getOutputKind());
        this.nativeLibs.processAnnotated();
        inv.addLibPath(tempDirectory.toString());
        for (String libraryPath : this.nativeLibs.getLibraryPaths()) {
            inv.addLibPath(libraryPath);
        }
        for (String rPath : OptionUtils.flatten(",", SubstrateOptions.LinkerRPath.getValue())) {
            inv.addRPath(rPath);
        }
        for (String library : this.nativeLibs.getLibraries()) {
            inv.addLinkedLibrary(library);
        }
        for (String filename : this.codeCache.getCCInputFiles(tempDirectory, imageName)) {
            inv.addInputFile(filename);
        }
        for (Path staticLibraryPath : this.nativeLibs.getStaticLibraries()) {
            inv.addInputFile(staticLibraryPath.toString());
        }
        return inv;
    }

    private static List<String> diagnoseLinkerFailure(String linkerOutput) {
        Pattern p;
        Matcher m;
        ArrayList<String> potentialCauses = new ArrayList<String>();
        if (linkerOutput.contains("access beyond end of merged section")) {
            potentialCauses.add("Native Image is using a linker that appears to be incompatible with the tool chain used to build the JDK static libraries. The latter is typically shown in the output of `java -Xinternalversion`.");
        }
        if ((m = (p = Pattern.compile(".*cannot find -l([^\\s]+)\\s.*", 32)).matcher(linkerOutput)).matches()) {
            OS os = OS.getCurrent();
            String libPrefix = os == OS.WINDOWS ? "" : "lib";
            String libSuffix = os == OS.WINDOWS ? ".lib" : ".a";
            potentialCauses.add(String.format("It appears as though %s%s%s is missing. Please install it.", libPrefix, m.group(1), libSuffix));
        }
        return potentialCauses;
    }

    @Override
    public LinkerInvocation write(DebugContext debug, Path outputDirectory, Path tempDirectory, String imageName, FeatureImpl.BeforeImageWriteAccessImpl config) {
        try (Indent indent = debug.logAndIndent("Writing native image");){
            String s2;
            this.write(tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix()));
            if (NativeImageOptions.ExitAfterRelocatableImageWrite.getValue().booleanValue()) {
                LinkerInvocation linkerInvocation = null;
                return linkerInvocation;
            }
            LinkerInvocation inv = this.getLinkerInvocation(outputDirectory, tempDirectory, imageName);
            for (Function<LinkerInvocation, LinkerInvocation> fn : config.getLinkerInvocationTransformers()) {
                inv = fn.apply(inv);
            }
            List<String> cmd = inv.getCommand();
            StringBuilder sb = new StringBuilder();
            for (String s2 : cmd) {
                if (s2.indexOf(32) != -1) {
                    sb.append('\'').append(s2).append('\'');
                } else {
                    sb.append(s2);
                }
                sb.append(' ');
            }
            String commandLine = sb.toString().trim();
            s2 = debug.scope((Object)"InvokeCC");
            Throwable throwable = null;
            try {
                int status;
                ByteArrayOutputStream output;
                debug.log("Running command: %s", (Object)sb);
                if (NativeImageOptions.MachODebugInfoTesting.getValue().booleanValue()) {
                    System.out.printf("Testing Mach-O debuginfo generation - SKIP %s%n", commandLine);
                    LinkerInvocation linkerInvocation = inv;
                    return linkerInvocation;
                }
                ProcessBuilder pb = new ProcessBuilder(new String[0]).command(cmd);
                pb.directory(tempDirectory.toFile());
                pb.redirectErrorStream(true);
                try {
                    Process p = pb.start();
                    output = new ByteArrayOutputStream();
                    FileUtils.drainInputStream(p.getInputStream(), output);
                    status = p.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    throw NativeBootImageViaCC.handleLinkerFailure(e.toString(), commandLine, null);
                }
                debug.log("%s", (Object)output);
                if (status != 0) {
                    throw NativeBootImageViaCC.handleLinkerFailure("Linker command exited with " + status, commandLine, output.toString());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (s2 != null) {
                    if (throwable != null) {
                        try {
                            s2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        s2.close();
                    }
                }
            }
            LinkerInvocation linkerInvocation = inv;
            return linkerInvocation;
        }
    }

    private static RuntimeException handleLinkerFailure(String message, String commandLine, String output) {
        List<Object> potentialCauses;
        Formatter buf = new Formatter();
        buf.format("There was an error linking the native image: %s%n%n", message);
        List<Object> list = potentialCauses = output == null ? Collections.emptyList() : NativeBootImageViaCC.diagnoseLinkerFailure(output);
        if (!potentialCauses.isEmpty()) {
            int causeNum = 1;
            buf.format("Based on the linker command output, possible reasons for this include:%n", new Object[0]);
            for (String string : potentialCauses) {
                buf.format("%d. %s%n", causeNum, string);
                ++causeNum;
            }
            buf.format("%n", new Object[0]);
        }
        buf.format("Linker command executed:%n%s", commandLine);
        if (output != null) {
            buf.format("%n%nLinker command ouput:%n%s", output);
        }
        throw new RuntimeException(buf.toString());
    }

    class WindowsCCLinkerInvocation
    extends CCLinkerInvocation {
        WindowsCCLinkerInvocation() {
            this.setCompilerCommand("CL");
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeBootImageViaCC.this.kind) {
                case EXECUTABLE: 
                case STATIC_EXECUTABLE: {
                    cmd.add("/MD");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("/MD");
                    cmd.add("/LD");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }

        @Override
        public List<String> getCommand() {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getCompilerCommand());
            this.setOutputKind(cmd);
            cmd.add("/Zi");
            if (NativeBootImageViaCC.removeUnusedSymbols()) {
                this.additionalPreOptions.add("/OPT:REF");
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                cmd.add("/PDBSTRIPPED");
            }
            cmd.add("/Fe" + this.outputFile.toString());
            cmd.addAll(this.inputFilenames);
            for (Path staticLibrary : NativeBootImageViaCC.this.nativeLibs.getStaticLibraries()) {
                cmd.add(staticLibrary.toString());
            }
            cmd.add("/link /INCREMENTAL:NO /NODEFAULTLIB:LIBCMT");
            for (String libraryPath : NativeBootImageViaCC.this.nativeLibs.getLibraryPaths()) {
                cmd.add("/LIBPATH:" + libraryPath);
            }
            for (String library : NativeBootImageViaCC.this.nativeLibs.getLibraries()) {
                cmd.add(library + ".lib");
            }
            cmd.add("advapi32.lib");
            cmd.add("ws2_32.lib");
            cmd.add("secur32.lib");
            cmd.add("iphlpapi.lib");
            cmd.add("userenv.lib");
            return cmd;
        }
    }

    class DarwinCCLinkerInvocation
    extends CCLinkerInvocation {
        DarwinCCLinkerInvocation() {
            if (!SubstrateOptions.CompilerBackend.getValue().equals("llvm")) {
                this.additionalPreOptions.add("-Wl,-no_compact_unwind");
            }
            if (NativeBootImageViaCC.removeUnusedSymbols()) {
                this.additionalPreOptions.add("-Wl,-dead_strip");
            }
            try {
                List<ObjectFile.Symbol> exportedSymbols = NativeBootImageViaCC.this.codeCache.getGlobalSymbols(NativeBootImageViaCC.this.getOrCreateDebugObjectFile());
                Path exportedSymbolsPath = NativeBootImageViaCC.this.nativeLibs.tempDirectory.resolve("exported_symbols.list");
                Files.write(exportedSymbolsPath, (Iterable<? extends CharSequence>)exportedSymbols.stream().map(symbol -> ((MachOSymtab.Entry)symbol).getNameInObject()).collect(Collectors.toList()), new OpenOption[0]);
                this.additionalPreOptions.add("-Wl,-exported_symbols_list");
                this.additionalPreOptions.add("-Wl," + exportedSymbolsPath.toAbsolutePath());
            }
            catch (IOException e) {
                VMError.shouldNotReachHere();
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
            this.additionalPreOptions.add("-arch");
            if (Platform.includedIn(Platform.AMD64.class)) {
                this.additionalPreOptions.add("x86_64");
            } else if (Platform.includedIn(Platform.AARCH64.class)) {
                this.additionalPreOptions.add("arm64");
            }
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeBootImageViaCC.this.kind) {
                case STATIC_EXECUTABLE: {
                    throw UserError.abort(OS.getCurrent().name() + " does not support building static executable images.", new Object[0]);
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    if (!Platform.includedIn(InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class)) break;
                    cmd.add("-undefined");
                    cmd.add("dynamic_lookup");
                }
            }
        }
    }

    class BinutilsCCLinkerInvocation
    extends CCLinkerInvocation {
        BinutilsCCLinkerInvocation() {
            this.additionalPreOptions.add("-z");
            this.additionalPreOptions.add("noexecstack");
            if (NativeBootImageViaCC.removeUnusedSymbols()) {
                this.additionalPreOptions.add("-Wl,--gc-sections");
            }
            if (!SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
                try {
                    ArrayList<String> exportedSymbols = new ArrayList<String>();
                    exportedSymbols.add("{");
                    NativeBootImageViaCC.this.codeCache.getGlobalSymbols(NativeBootImageViaCC.this.getOrCreateDebugObjectFile()).stream().map(symbol -> "\"" + symbol.getName() + "\";").forEachOrdered(exportedSymbols::add);
                    exportedSymbols.add("};");
                    Path exportedSymbolsPath = NativeBootImageViaCC.this.nativeLibs.tempDirectory.resolve("exported_symbols.list");
                    Files.write(exportedSymbolsPath, exportedSymbols, new OpenOption[0]);
                    this.additionalPreOptions.add("-Wl,--dynamic-list");
                    this.additionalPreOptions.add("-Wl," + exportedSymbolsPath.toAbsolutePath());
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere();
                }
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
            LibCBase currentLibc = (LibCBase)ImageSingletons.lookup(LibCBase.class);
            this.additionalPreOptions.addAll(currentLibc.getLinkerPreOptions());
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeBootImageViaCC.this.kind) {
                case EXECUTABLE: {
                    break;
                }
                case STATIC_EXECUTABLE: {
                    cmd.add("-static");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }
    }
}

