/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.util.ImageGeneratorThreadMarker;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.MappedByteBuffer;
import java.util.zip.ZipFile;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class DisallowedImageHeapObjectFeature
implements Feature {
    private ClassInitializationSupport classInitialization;
    private static final Class<?> CANCELLABLE_CLASS;
    private static final Field FILE_DESCRIPTOR_FIELD;

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.classInitialization = ((FeatureImpl.DuringSetupAccessImpl)access).getHostVM().getClassInitializationSupport();
        access.registerObjectReplacer(this::replacer);
    }

    private Object replacer(Object original) {
        FileDescriptor asFileDescriptor;
        if (original instanceof Thread) {
            Thread asThread = (Thread)original;
            if (asThread instanceof ImageGeneratorThreadMarker) {
                return ((ImageGeneratorThreadMarker)asThread).asTerminated();
            }
            if (asThread.getState() != Thread.State.NEW && asThread.getState() != Thread.State.TERMINATED) {
                throw DisallowedImageHeapObjectFeature.error("Detected a started Thread in the image heap. Threads running in the image generator are no longer running at image run time. " + this.classInitialization.objectInstantiationTraceMessage(asThread, "Try avoiding to initialize the class that caused initialization of the Thread."));
            }
        }
        if (original instanceof FileDescriptor && (asFileDescriptor = (FileDescriptor)original) != FileDescriptor.in && asFileDescriptor != FileDescriptor.out && asFileDescriptor != FileDescriptor.err && asFileDescriptor.valid()) {
            throw DisallowedImageHeapObjectFeature.error("Detected a FileDescriptor in the image heap. File descriptors opened during image generation are no longer open at image run time, and the files might not even be present anymore at image run time. " + this.classInitialization.objectInstantiationTraceMessage(asFileDescriptor, "Try avoiding to initialize the class that caused initialization of the FileDescriptor."));
        }
        if (original instanceof MappedByteBuffer) {
            MappedByteBuffer buffer = (MappedByteBuffer)original;
            if (buffer.capacity() != 0 || DisallowedImageHeapObjectFeature.getFileDescriptor(buffer) != null) {
                throw DisallowedImageHeapObjectFeature.error("Detected a direct/mapped ByteBuffer in the image heap. A direct ByteBuffer has a pointer to unmanaged C memory, and C memory from the image generator is not available at image run time. A mapped ByteBuffer references a file descriptor, which is no longer open and mapped at run time. " + this.classInitialization.objectInstantiationTraceMessage(buffer, "Try avoiding to initialize the class that caused initialization of the MappedByteBuffer."));
            }
        } else if (original instanceof Buffer && ((Buffer)original).isDirect()) {
            throw DisallowedImageHeapObjectFeature.error("Detected a direct Buffer in the image heap. A direct Buffer has a pointer to unmanaged C memory, and C memory from the image generator is not available at image run time. " + this.classInitialization.objectInstantiationTraceMessage(original, "Try avoiding to initialize the class that caused initialization of the direct Buffer."));
        }
        if (original instanceof ZipFile) {
            throw DisallowedImageHeapObjectFeature.error("Detected a ZipFile object in the image heap. A ZipFile object contains pointers to unmanaged C memory and file descriptors, and these resources are no longer available at image run time. " + this.classInitialization.objectInstantiationTraceMessage(original, "Try avoiding to initialize the class that caused initialization of the direct Buffer."));
        }
        if (CANCELLABLE_CLASS.isInstance(original)) {
            throw DisallowedImageHeapObjectFeature.error("Detected an instance of a class that extends " + CANCELLABLE_CLASS.getTypeName() + ": " + original.getClass().getTypeName() + ". It contains a pointer to unmanaged C memory, which is no longer available at image run time. " + this.classInitialization.objectInstantiationTraceMessage(original, "Try avoiding to initialize the class that caused initialization of the object."));
        }
        return original;
    }

    private static RuntimeException error(String msg) {
        throw new UnsupportedFeatureException(msg + " The object was probably created by a class initializer and is reachable from a static field. You can request class initialization at image run time by using the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, "<class-name>", "initialize-at-run-time") + ". Or you can write your own initialization methods and call them explicitly from your main entry point.");
    }

    private static FileDescriptor getFileDescriptor(MappedByteBuffer buffer) {
        try {
            return (FileDescriptor)FILE_DESCRIPTOR_FIELD.get(buffer);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    static {
        try {
            CANCELLABLE_CLASS = Class.forName("sun.nio.fs.Cancellable");
        }
        catch (ClassNotFoundException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        FILE_DESCRIPTOR_FIELD = ReflectionUtil.lookupField(MappedByteBuffer.class, (String)"fd");
    }
}

