/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.InitializationNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClassInitializationConfiguration {
    private static final String ROOT_QUALIFIER = "";
    private static final int MAX_NUMBER_OF_REASONS = 3;
    private InitializationNode root = new InitializationNode("", null, null, new String[0]);

    public synchronized void insert(String classOrPackage, InitKind kind, String reason) {
        assert (kind != null);
        this.insertRec(this.root, ClassInitializationConfiguration.qualifierList(classOrPackage), kind, reason);
    }

    synchronized InitKind lookupKind(String classOrPackage) {
        InitializationNode node = this.lookupRec(this.root, ClassInitializationConfiguration.qualifierList(classOrPackage), null);
        return node == null ? null : node.kind;
    }

    synchronized String lookupReason(String classOrPackage) {
        assert (this.lookupRec(this.root, ClassInitializationConfiguration.qualifierList(classOrPackage), null) != null) : "Path for a file should be ";
        return String.join((CharSequence)" and ", this.lookupRec((InitializationNode)this.root, ClassInitializationConfiguration.qualifierList((String)classOrPackage), null).reasons);
    }

    private static List<String> qualifierList(String classOrPackage) {
        List qualifiers = classOrPackage.isEmpty() ? Collections.emptyList() : Arrays.asList(classOrPackage.split("\\."));
        ArrayList<String> prefixed = new ArrayList<String>(Collections.singletonList(ROOT_QUALIFIER));
        prefixed.addAll(qualifiers);
        return prefixed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertRec(InitializationNode node, List<String> classOrPackage, InitKind kind, String reason) {
        assert (!classOrPackage.isEmpty());
        assert (node.qualifier.equals(classOrPackage.get(0)));
        if (classOrPackage.size() == 1) {
            if (node.kind == null) {
                node.kind = kind;
                return;
            } else {
                if (node.kind != kind) throw UserError.abort("Incompatible change of initialization policy for " + ClassInitializationConfiguration.qualifiedName(node) + ": trying to change " + (Object)((Object)node.kind) + " " + String.join((CharSequence)" and ", node.reasons) + " to " + (Object)((Object)kind) + " " + reason, new Object[0]);
                if (node.reasons.size() < 3) {
                    node.reasons.add((Object)reason);
                    return;
                } else {
                    if (node.reasons.size() != 3) return;
                    node.reasons.add((Object)"others");
                }
            }
            return;
        } else {
            ArrayList<String> tail = new ArrayList<String>(classOrPackage);
            tail.remove(0);
            String nextQualifier = (String)tail.get(0);
            if (!node.children.containsKey((Object)nextQualifier)) {
                node.children.put((Object)nextQualifier, (Object)new InitializationNode(nextQualifier, node, null, reason));
                assert (node.children.containsKey((Object)nextQualifier));
            }
            this.insertRec((InitializationNode)node.children.get((Object)nextQualifier), tail, kind, reason);
        }
    }

    private InitializationNode lookupRec(InitializationNode node, List<String> classOrPackage, InitializationNode lastNonNullKind) {
        ArrayList<String> tail = new ArrayList<String>(classOrPackage);
        tail.remove(0);
        if (!tail.isEmpty() && node.children.containsKey(tail.get(0))) {
            return this.lookupRec((InitializationNode)node.children.get(tail.get(0)), tail, node.kind != null ? node : lastNonNullKind);
        }
        if (node.kind == null) {
            return lastNonNullKind;
        }
        return node;
    }

    private static String qualifiedName(InitializationNode node) {
        InitializationNode currentNode = node;
        ArrayList<String> name = new ArrayList<String>();
        while (currentNode != null) {
            name.add(currentNode.qualifier);
            currentNode = currentNode.parent;
        }
        Collections.reverse(name);
        name.remove(0);
        return String.join((CharSequence)".", name);
    }

    synchronized List<ClassOrPackageConfig> allConfigs() {
        LinkedList<InitializationNode> printingQueue = new LinkedList<InitializationNode>();
        printingQueue.add(this.root);
        ArrayList<ClassOrPackageConfig> allClasses = new ArrayList<ClassOrPackageConfig>();
        while (!printingQueue.isEmpty()) {
            InitializationNode node = (InitializationNode)printingQueue.remove();
            if (node.kind != null) {
                String name = node.qualifier.isEmpty() ? "whole type hierarchy" : ClassInitializationConfiguration.qualifiedName(node);
                allClasses.add(new ClassOrPackageConfig(name, node.reasons, node.kind));
            }
            node.children.getValues().forEach(printingQueue::push);
        }
        return allClasses;
    }
}

