/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CAnnotationProcessorCache;
import com.oracle.svm.hosted.c.CInterfaceError;
import com.oracle.svm.hosted.c.NativeCodeContext;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.c.codegen.QueryCodeWriter;
import com.oracle.svm.hosted.c.info.InfoTreeBuilder;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.query.QueryResultParser;
import com.oracle.svm.hosted.c.query.RawStructureLayoutPlanner;
import com.oracle.svm.hosted.c.query.SizeAndSignednessVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class CAnnotationProcessor
extends CCompilerInvoker {
    private final NativeCodeContext codeCtx;
    private NativeCodeInfo codeInfo;
    private QueryCodeWriter writer;

    public CAnnotationProcessor(NativeLibraries nativeLibs, NativeCodeContext codeCtx, Path tempDirectory) {
        super(nativeLibs, tempDirectory);
        this.codeCtx = codeCtx;
    }

    public NativeCodeInfo process(CAnnotationProcessorCache cache) {
        InfoTreeBuilder constructor = new InfoTreeBuilder(this.nativeLibs, this.codeCtx);
        this.codeInfo = constructor.construct();
        if (this.nativeLibs.getErrors().size() > 0) {
            return this.codeInfo;
        }
        if (CAnnotationProcessorCache.Options.UseCAPCache.getValue().booleanValue()) {
            cache.get(this.nativeLibs, this.codeInfo);
        } else {
            this.writer = new QueryCodeWriter(this.tempDirectory);
            Path queryFile = this.writer.write(this.codeInfo);
            if (this.nativeLibs.getErrors().size() > 0) {
                return this.codeInfo;
            }
            assert (Files.exists(queryFile, new LinkOption[0]));
            Path binary = this.compileQueryCode(queryFile);
            if (this.nativeLibs.getErrors().size() > 0) {
                return this.codeInfo;
            }
            this.makeQuery(cache, binary.toString());
            if (this.nativeLibs.getErrors().size() > 0) {
                return this.codeInfo;
            }
        }
        RawStructureLayoutPlanner.plan(this.nativeLibs, this.codeInfo);
        SizeAndSignednessVerifier.verify(this.nativeLibs, this.codeInfo);
        return this.codeInfo;
    }

    private void makeQuery(CAnnotationProcessorCache cache, String binaryName) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(binaryName);
        Process printingProcess = null;
        try {
            printingProcess = this.startCommand(command);
            InputStream is = printingProcess.getInputStream();
            List<String> lines = QueryResultParser.parse(this.nativeLibs, this.codeInfo, is);
            is.close();
            if (CAnnotationProcessorCache.Options.NewCAPCache.getValue().booleanValue()) {
                cache.put(this.codeInfo, lines);
            }
            printingProcess.waitFor();
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding();
        }
        finally {
            if (printingProcess != null) {
                printingProcess.destroy();
            }
        }
    }

    private Path compileQueryCode(Path queryFile) {
        String binaryName = queryFile.toString().substring(0, queryFile.toString().lastIndexOf("."));
        if (OS.getCurrent() == OS.WINDOWS) {
            binaryName = binaryName + ".exe";
        }
        Path binary = Paths.get(binaryName, new String[0]);
        return this.compileAndParseError(this.codeCtx.getDirectives().getOptions(), queryFile.normalize(), binary.normalize());
    }

    @Override
    protected void reportCompilerError(Path queryFile, String line) {
        int secondColon;
        int firstColon;
        for (String header : this.codeCtx.getDirectives().getHeaderFiles()) {
            if (!line.contains(header.substring(1, header.length() - 1) + ": No such file or directory")) continue;
            UserError.abort("Basic header file missing (" + header + "). Make sure headers are available on your system.", new Object[0]);
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        int fileNameStart = line.indexOf(queryFile.toString());
        if (fileNameStart != -1 && (firstColon = line.indexOf(58, fileNameStart + 1)) != -1 && (secondColon = line.indexOf(58, firstColon + 1)) != -1) {
            String lineNumberStr = line.substring(firstColon + 1, secondColon);
            try {
                int lineNumber = Integer.parseInt(lineNumberStr);
                elements.add(this.writer.getElementForLineNumber(lineNumber));
                elements.add("C file contents around line " + lineNumber + ":");
                for (int i = Math.max(lineNumber - 1, 1); i <= lineNumber + 1; ++i) {
                    elements.add(queryFile.toString() + ":" + i + ": " + this.writer.getLine(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.nativeLibs.getErrors().add(new CInterfaceError("Error compiling query code (in " + queryFile + "). Compiler command " + this.lastExecutedCommand() + " output included error: " + line, elements));
    }
}

