/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.DeoptimizationSourcePositionEncoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.InstantReferenceAdjuster;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.heap.CodeReferenceMapEncoder;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class RuntimeCodeInstaller {
    protected final SharedRuntimeMethod method;
    private final int tier;
    private final boolean testTrampolineJumps;
    private SubstrateCompilationResult compilation;
    private Pointer code;
    private int codeSize;
    private int constantsOffset;
    private InstalledCodeObserver[] codeObservers;
    protected byte[] compiledBytes;

    public static void install(SharedRuntimeMethod method, CompilationResult compilation, SubstrateInstalledCode installedCode) {
        RuntimeCodeInstaller.install(method, compilation, installedCode, false);
    }

    public static void install(SharedRuntimeMethod method, CompilationResult compilation, SubstrateInstalledCode installedCode, boolean testTrampolineJumps) {
        new RuntimeCodeInstaller(method, compilation, testTrampolineJumps).doInstall(installedCode);
    }

    protected RuntimeCodeInstaller(SharedRuntimeMethod method, CompilationResult compilation, boolean testTrampolineJumps) {
        this.method = method;
        this.compilation = (SubstrateCompilationResult)compilation;
        this.tier = compilation.getName().endsWith("#1") ? 1 : 2;
        this.testTrampolineJumps = testTrampolineJumps;
    }

    private void prepareCodeMemory() {
        try (Indent indent = DebugContext.forCurrentThread().logAndIndent("create installed code of %s.%s", (Object)this.method.getDeclaringClass().getName(), (Object)this.method.getName());){
            SubstrateTargetDescription target = ConfigurationValues.getTarget();
            if (target.arch.getPlatformKind(JavaKind.Object).getSizeInBytes() != 8) {
                throw VMError.shouldNotReachHere("wrong object size");
            }
            int constantsSize = this.compilation.getDataSection().getSectionSize();
            this.codeSize = this.compilation.getTargetCodeSize();
            int tmpConstantsOffset = NumUtil.roundUp((int)this.codeSize, (int)this.compilation.getDataSection().getSectionAlignment());
            if (!RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
                tmpConstantsOffset = (int)NumUtil.roundUp((long)tmpConstantsOffset, (long)CommittedMemoryProvider.get().getGranularity().rawValue());
            }
            int tmpMemorySize = tmpConstantsOffset + constantsSize;
            this.code = this.allocateCodeMemory(tmpMemorySize);
            HashSet<Long> directTargets = new HashSet<Long>();
            boolean needTrampolineJumps = this.testTrampolineJumps;
            for (Infopoint infopoint : this.compilation.getInfopoints()) {
                if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
                Call call = (Call)infopoint;
                long targetAddress = RuntimeCodeInstaller.getTargetCodeAddress(call);
                long pcDisplacement = targetAddress - (this.code.rawValue() + (long)call.pcOffset);
                if (!RuntimeCodeInstaller.platformHelper().targetWithinPCDisplacement(pcDisplacement)) {
                    needTrampolineJumps = true;
                }
                directTargets.add(targetAddress);
            }
            this.compiledBytes = this.compilation.getTargetCode();
            if (needTrampolineJumps) {
                this.releaseCodeMemory(this.code, tmpMemorySize);
                tmpConstantsOffset = NumUtil.roundUp((int)(this.codeSize + directTargets.size() * RuntimeCodeInstaller.platformHelper().getTrampolineCallSize()), (int)8);
                tmpConstantsOffset = NumUtil.roundUp((int)(tmpConstantsOffset + directTargets.size() * 8), (int)this.compilation.getDataSection().getSectionAlignment());
                if (!RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
                    tmpConstantsOffset = (int)NumUtil.roundUp((long)tmpConstantsOffset, (long)CommittedMemoryProvider.get().getGranularity().rawValue());
                }
                if (tmpConstantsOffset > this.compiledBytes.length) {
                    this.compiledBytes = Arrays.copyOf(this.compiledBytes, tmpConstantsOffset);
                }
                tmpMemorySize = tmpConstantsOffset + constantsSize;
                this.code = this.allocateCodeMemory(tmpMemorySize);
            }
            this.constantsOffset = tmpConstantsOffset;
            if (!RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
                this.makeDataSectionNX(this.code.add(this.constantsOffset), constantsSize);
            }
            this.codeObservers = ((InstalledCodeObserverSupport)ImageSingletons.lookup(InstalledCodeObserverSupport.class)).createObservers(DebugContext.forCurrentThread(), this.method, this.compilation, this.code);
        }
    }

    private void doInstall(SubstrateInstalledCode installedCode) {
        InstantReferenceAdjuster adjuster = new InstantReferenceAdjuster();
        CodeInfo codeInfo = RuntimeCodeInfoAccess.allocateMethodInfo();
        this.doPrepareInstall(adjuster, codeInfo);
        RuntimeCodeInstaller.doInstallPrepared(this.method, codeInfo, installedCode);
    }

    protected void doPrepareInstall(ReferenceAdjuster adjuster, CodeInfo codeInfo) {
        this.prepareCodeMemory();
        ObjectConstantsHolder objectConstants = new ObjectConstantsHolder(this.compilation);
        HashMap<Integer, NativeImagePatcher> patches = new HashMap<Integer, NativeImagePatcher>();
        for (CompilationResult.CodeAnnotation codeAnnotation : this.compilation.getCodeAnnotations()) {
            if (!(codeAnnotation instanceof NativeImagePatcher)) continue;
            patches.put(codeAnnotation.getPosition(), (NativeImagePatcher)codeAnnotation);
        }
        this.patchData(patches, objectConstants);
        int updatedCodeSize = this.patchCalls(patches);
        assert (updatedCodeSize <= this.constantsOffset);
        for (int index = 0; index < updatedCodeSize; ++index) {
            this.code.writeByte(index, this.compiledBytes[index]);
        }
        if (!RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
            this.makeCodeMemoryReadOnly(this.code, this.codeSize);
        }
        ByteBuffer constantsBuffer = CTypeConversion.asByteBuffer((PointerBase)this.code.add(this.constantsOffset), (int)this.compilation.getDataSection().getSectionSize());
        this.compilation.getDataSection().buildDataSection(constantsBuffer, (position, constant) -> objectConstants.add(this.constantsOffset + position, ConfigurationValues.getObjectLayout().getReferenceSize(), (SubstrateObjectConstant)constant));
        NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles = InstalledCodeObserverSupport.installObservers(this.codeObservers);
        RuntimeCodeInfoAccess.initialize(codeInfo, this.code, this.codeSize, this.tier, observerHandles);
        CodeReferenceMapEncoder encoder = new CodeReferenceMapEncoder();
        encoder.add(objectConstants.referenceMap);
        RuntimeCodeInfoAccess.setCodeObjectConstantsInfo(codeInfo, encoder.encodeAll(), encoder.lookupEncoding(objectConstants.referenceMap));
        this.patchDirectObjectConstants(objectConstants, codeInfo, adjuster);
        this.createCodeChunkInfos(codeInfo, adjuster);
        this.compilation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doInstallPrepared(SharedMethod method, CodeInfo codeInfo, SubstrateInstalledCode installedCode) {
        CodeInfoTether tether = RuntimeCodeInfoAccess.beforeInstallInCurrentIsolate(codeInfo, installedCode);
        try {
            Throwable[] errorBox = new Throwable[]{null};
            JavaVMOperation.enqueueBlockingSafepoint("Install code", () -> {
                try {
                    CodeInfoTable.getRuntimeCodeCache().addMethod(codeInfo);
                    CodePointer codeStart = CodeInfoAccess.getCodeStart(codeInfo);
                    RuntimeCodeInstaller.platformHelper().performCodeSynchronization(codeInfo);
                    installedCode.setAddress(codeStart.rawValue(), method);
                }
                catch (Throwable e) {
                    errorBox[0] = e;
                }
            });
            if (errorBox[0] != null) {
                throw RuntimeCodeInstaller.rethrow(errorBox[0]);
            }
        }
        finally {
            CodeInfoAccess.releaseTether(codeInfo, tether);
        }
    }

    protected static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    @Uninterruptible(reason="Must be atomic with regard to garbage collection.")
    private void patchDirectObjectConstants(ObjectConstantsHolder objectConstants, CodeInfo runtimeMethodInfo, ReferenceAdjuster adjuster) {
        for (int i = 0; i < objectConstants.count; ++i) {
            SubstrateObjectConstant constant = objectConstants.constants[i];
            adjuster.setConstantTargetAt((PointerBase)this.code.add(objectConstants.offsets[i]), objectConstants.lengths[i], constant);
        }
        CodeInfoAccess.setState(runtimeMethodInfo, 1);
    }

    private void createCodeChunkInfos(CodeInfo runtimeMethodInfo, ReferenceAdjuster adjuster) {
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(new FrameInfoEncoder.NamesFromImage());
        codeInfoEncoder.addMethod(this.method, this.compilation, 0);
        codeInfoEncoder.encodeAllAndInstall(runtimeMethodInfo, adjuster);
        assert (!adjuster.isFinished() || CodeInfoEncoder.verifyMethod(this.method, this.compilation, 0, runtimeMethodInfo));
        assert (!adjuster.isFinished() || codeInfoEncoder.verifyFrameInfo(runtimeMethodInfo));
        DeoptimizationSourcePositionEncoder sourcePositionEncoder = new DeoptimizationSourcePositionEncoder();
        sourcePositionEncoder.encodeAndInstall(this.compilation.getDeoptimizationSourcePositions(), runtimeMethodInfo);
    }

    private void patchData(Map<Integer, NativeImagePatcher> patcher, ObjectConstantsHolder objectConstants) {
        for (DataPatch dataPatch : this.compilation.getDataPatches()) {
            DataSectionReference ref;
            NativeImagePatcher patch = patcher.get(dataPatch.pcOffset);
            if (dataPatch.reference instanceof DataSectionReference) {
                ref = (DataSectionReference)dataPatch.reference;
                int pcDisplacement = this.constantsOffset + ref.getOffset() - dataPatch.pcOffset;
                patch.patchCode(pcDisplacement, this.compiledBytes);
                continue;
            }
            if (!(dataPatch.reference instanceof ConstantReference)) continue;
            ref = (ConstantReference)dataPatch.reference;
            SubstrateObjectConstant refConst = (SubstrateObjectConstant)ref.getConstant();
            objectConstants.add(patch.getOffset(), patch.getLength(), refConst);
        }
    }

    private int patchCalls(Map<Integer, NativeImagePatcher> patches) {
        HashMap<Long, Integer> directTargets = new HashMap<Long, Integer>();
        int currentPos = this.codeSize;
        for (Infopoint infopoint : this.compilation.getInfopoints()) {
            if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
            Call call = (Call)infopoint;
            long targetAddress = RuntimeCodeInstaller.getTargetCodeAddress(call);
            long pcDisplacement = targetAddress - (this.code.rawValue() + (long)call.pcOffset);
            if (!RuntimeCodeInstaller.platformHelper().targetWithinPCDisplacement(pcDisplacement) || this.testTrampolineJumps) {
                Long destAddr = targetAddress;
                Integer trampolineOffset = (Integer)directTargets.get(destAddr);
                if (trampolineOffset == null) {
                    trampolineOffset = currentPos;
                    directTargets.put(destAddr, trampolineOffset);
                    currentPos += RuntimeCodeInstaller.platformHelper().getTrampolineCallSize();
                }
                pcDisplacement = trampolineOffset - call.pcOffset;
            }
            assert (RuntimeCodeInstaller.platformHelper().targetWithinPCDisplacement(pcDisplacement)) : "target not within pc displacement";
            patches.get(call.pcOffset).patchCode((int)pcDisplacement, this.compiledBytes);
        }
        if (directTargets.size() > 0) {
            currentPos = RuntimeCodeInstaller.platformHelper().insertTrampolineCalls(this.compiledBytes, currentPos, directTargets);
        }
        return currentPos;
    }

    protected static RuntimeCodeInstallerPlatformHelper platformHelper() {
        return (RuntimeCodeInstallerPlatformHelper)ImageSingletons.lookup(RuntimeCodeInstallerPlatformHelper.class);
    }

    private static long getTargetCodeAddress(Call callInfo) {
        SharedMethod targetMethod = (SharedMethod)callInfo.target;
        long callTargetStart = CodeInfoAccess.absoluteIP(CodeInfoTable.getImageCodeInfo(), targetMethod.getCodeOffsetInImage()).rawValue();
        if (callTargetStart == 0L) {
            throw VMError.shouldNotReachHere("target method not compiled: " + targetMethod.format("%H.%n(%p)"));
        }
        return callTargetStart;
    }

    protected Pointer allocateCodeMemory(long size) {
        CodePointer result = RuntimeCodeInfoAccess.allocateCodeMemory(WordFactory.unsigned((long)size));
        if (result.isNull()) {
            throw new OutOfMemoryError();
        }
        return (Pointer)result;
    }

    protected void makeCodeMemoryReadOnly(Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryExecutableReadOnly((CodePointer)start, WordFactory.unsigned((long)size));
    }

    protected void makeDataSectionNX(Pointer start, long size) {
        RuntimeCodeInfoAccess.makeCodeMemoryWriteableNonExecutable((CodePointer)start, WordFactory.unsigned((long)size));
    }

    protected void releaseCodeMemory(Pointer start, long size) {
        RuntimeCodeInfoAccess.releaseCodeMemory((CodePointer)start, WordFactory.unsigned((long)size));
    }

    public static interface RuntimeCodeInstallerPlatformHelper {
        public boolean targetWithinPCDisplacement(long var1);

        public int getTrampolineCallSize();

        public int insertTrampolineCalls(byte[] var1, int var2, Map<Long, Integer> var3);

        public void performCodeSynchronization(CodeInfo var1);
    }

    private static class ObjectConstantsHolder {
        final SubstrateReferenceMap referenceMap;
        final int[] offsets;
        final int[] lengths;
        final SubstrateObjectConstant[] constants;
        int count;

        ObjectConstantsHolder(CompilationResult compilation) {
            int maxDataRefs = compilation.getDataSection().getSectionSize() / ConfigurationValues.getObjectLayout().getReferenceSize();
            int maxCodeRefs = compilation.getDataPatches().size();
            int maxTotalRefs = maxDataRefs + maxCodeRefs;
            this.offsets = new int[maxTotalRefs];
            this.lengths = new int[maxTotalRefs];
            this.constants = new SubstrateObjectConstant[maxTotalRefs];
            this.referenceMap = new SubstrateReferenceMap();
        }

        void add(int offset, int length, SubstrateObjectConstant constant) {
            assert (constant.isCompressed() == ReferenceAccess.singleton().haveCompressedReferences()) : "Object reference constants in code must be compressed";
            this.offsets[this.count] = offset;
            this.lengths[this.count] = length;
            this.constants[this.count] = constant;
            this.referenceMap.markReferenceAtOffset(offset, true);
            ++this.count;
        }
    }
}

