/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibC;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
public class WindowsSystemPropertiesSupport
extends SystemPropertiesSupport {
    private static final byte[] USERNAME = "USERNAME\u0000".getBytes(StandardCharsets.UTF_16LE);

    @Override
    protected String userNameValue() {
        LibC.WCharPointer userName = LibC._wgetenv((LibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)USERNAME), 0));
        UnsignedWord length = LibC.wcslen(userName);
        if (userName.isNonNull() && length.aboveThan(0)) {
            return WindowsSystemPropertiesSupport.toJavaString(userName, length);
        }
        int maxLength = 257;
        userName = (LibC.WCharPointer)StackValue.get((int)maxLength, LibC.WCharPointer.class);
        CIntPointer lengthPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        lengthPointer.write(maxLength);
        if (WinBase.GetUserNameW(userName, lengthPointer) == 0) {
            return "unknown";
        }
        return WindowsSystemPropertiesSupport.toJavaString(userName, WordFactory.unsigned((int)(lengthPointer.read() - 1)));
    }

    @Override
    protected String userHomeValue() {
        WinBase.LPHANDLE tokenHandle = (WinBase.LPHANDLE)StackValue.get(WinBase.LPHANDLE.class);
        if (Process.OpenProcessToken(Process.GetCurrentProcess(), 8, tokenHandle) == 0) {
            return "C:\\";
        }
        int initialLen = 261;
        CIntPointer buffLenPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        buffLenPointer.write(initialLen);
        LibC.WCharPointer userHome = (LibC.WCharPointer)StackValue.get((int)initialLen, LibC.WCharPointer.class);
        int result = WinBase.GetUserProfileDirectoryW(tokenHandle.read(), userHome, buffLenPointer);
        WinBase.CloseHandle(tokenHandle.read());
        if (result == 0) {
            return "C:\\";
        }
        return WindowsSystemPropertiesSupport.toJavaString(userHome, WordFactory.unsigned((int)(buffLenPointer.read() - 1)));
    }

    @Override
    protected String userDirValue() {
        int maxLength = 260;
        LibC.WCharPointer userDir = (LibC.WCharPointer)StackValue.get((int)maxLength, LibC.WCharPointer.class);
        int length = WinBase.GetCurrentDirectoryW(maxLength, userDir);
        VMError.guarantee(length > 0 && length < maxLength, "Could not determine value of user.dir");
        return WindowsSystemPropertiesSupport.toJavaString(userDir, WordFactory.unsigned((int)length));
    }

    @Override
    protected String tmpdirValue() {
        int maxLength = 261;
        LibC.WCharPointer tmpdir = (LibC.WCharPointer)StackValue.get((int)maxLength, LibC.WCharPointer.class);
        int length = FileAPI.GetTempPathW(maxLength, tmpdir);
        VMError.guarantee(length > 0, "Could not determine value of java.io.tmpdir");
        return WindowsSystemPropertiesSupport.toJavaString(tmpdir, WordFactory.unsigned((int)length));
    }

    private static String toJavaString(LibC.WCharPointer wcString, UnsignedWord length) {
        return CTypeConversion.toJavaString((CCharPointer)((CCharPointer)wcString), (UnsignedWord)SizeOf.unsigned(LibC.WCharPointer.class).multiply(length), (Charset)StandardCharsets.UTF_16LE);
    }

    @Override
    protected String osVersionValue() {
        ByteBuffer versionBytes = ByteBuffer.allocate(4);
        versionBytes.putInt(WinBase.GetVersion());
        byte majorVersion = versionBytes.get(3);
        byte minorVersion = versionBytes.get(2);
        return majorVersion + "." + minorVersion;
    }
}

