/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
class WindowsParkEvent
extends ParkEvent {
    private final WinBase.HANDLE eventHandle = SynchAPI.CreateEventA(WordFactory.nullPointer(), 0, 0, WordFactory.nullPointer());

    WindowsParkEvent() {
        VMError.guarantee(this.eventHandle.rawValue() != 0L, "CreateEventA failed");
    }

    @Override
    protected void reset() {
        SynchAPI.ResetEvent(this.eventHandle);
    }

    @Override
    protected ParkEvent.WaitResult condWait() {
        if (this.resetEventBeforeWait) {
            this.reset();
        }
        if (Thread.currentThread().isInterrupted()) {
            return ParkEvent.WaitResult.INTERRUPTED;
        }
        int status = SynchAPI.WaitForSingleObject(this.eventHandle, SynchAPI.INFINITE());
        if (status != SynchAPI.WAIT_OBJECT_0()) {
            Log.log().newline().string("WindowsParkEvent.condWait failed, status returned:  ").hex(status);
            Log.log().newline().string("GetLastError returned:  ").hex(WinBase.GetLastError()).newline();
            throw VMError.shouldNotReachHere("WaitForSingleObject failed");
        }
        return ParkEvent.WaitResult.UNPARKED;
    }

    @Override
    protected ParkEvent.WaitResult condTimedWait(long delayNanos) {
        int timeout;
        if (this.resetEventBeforeWait) {
            this.reset();
        }
        if (Thread.currentThread().isInterrupted()) {
            return ParkEvent.WaitResult.INTERRUPTED;
        }
        int maxTimeout = 0x10000000;
        long delayMillis = Math.max(0L, TimeUtils.roundNanosToMillis(delayNanos));
        do {
            int status;
            if ((status = SynchAPI.WaitForSingleObject(this.eventHandle, timeout = delayMillis < 0x10000000L ? (int)delayMillis : 0x10000000)) == SynchAPI.WAIT_OBJECT_0()) {
                return ParkEvent.WaitResult.UNPARKED;
            }
            if (status == SynchAPI.WAIT_TIMEOUT()) continue;
            Log.log().newline().string("WindowsParkEvent.condTimedWait failed, status returned:  ").hex(status);
            Log.log().newline().string("GetLastError returned:  ").hex(WinBase.GetLastError()).newline();
            throw VMError.shouldNotReachHere("WaitForSingleObject failed");
        } while ((delayMillis -= (long)timeout) > 0L);
        return ParkEvent.WaitResult.TIMED_OUT;
    }

    @Override
    protected void unpark() {
        SynchAPI.SetEvent(this.eventHandle);
    }
}

