/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.ForceFixedRegisterReads;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CFunctionOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public abstract class VMThreads {
    protected static final VMMutex THREAD_MUTEX = new VMMutex();
    protected static final VMCondition THREAD_LIST_CONDITION = new VMCondition(THREAD_MUTEX);
    private static IsolateThread head;
    private static UninterruptibleUtils.AtomicWord<OSThreadHandle> detachedOsThreadToCleanup;
    public static final FastThreadLocalWord<IsolateThread> nextTL;
    private static final FastThreadLocalWord<OSThreadId> OSThreadIdTL;
    protected static final FastThreadLocalWord<OSThreadHandle> OSThreadHandleTL;
    public static final FastThreadLocalWord<Isolate> IsolateTL;
    private static final int STATE_UNINITIALIZED = 1;
    private static final int STATE_INITIALIZING = 2;
    private static final int STATE_INITIALIZED = 3;
    private static final int STATE_TEARING_DOWN = 4;
    private static final UninterruptibleUtils.AtomicInteger initializationState;

    @Fold
    public static VMThreads singleton() {
        return (VMThreads)ImageSingletons.lookup(VMThreads.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean isInitialized() {
        return initializationState.get() >= 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code during tear down.")
    static boolean isTearingDown() {
        return initializationState.get() >= 4;
    }

    static void setTearingDown() {
        initializationState.set(4);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean ensureInitialized() {
        boolean result = true;
        if (initializationState.compareAndSet(1, 2)) {
            result = VMThreads.singleton().initializeOnce();
            initializationState.set(3);
        } else {
            while (initializationState.get() < 3) {
            }
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    protected abstract boolean initializeOnce();

    @Uninterruptible(reason="Thread state not set up.")
    public abstract IsolateThread allocateIsolateThread(int var1);

    @Uninterruptible(reason="Thread state not set up.")
    public abstract void freeIsolateThread(IsolateThread var1);

    @Uninterruptible(reason="Unknown thread state.")
    public abstract void failFatally(int var1, CCharPointer var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThread() {
        VMThreads.guaranteeOwnsThreadMutex("Threads mutex must be locked before accessing/iterating the thread list.");
        return VMThreads.firstThreadUnsafe();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThreadUnsafe() {
        return head;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread nextThread(IsolateThread cur) {
        return nextTL.get(cur);
    }

    @Uninterruptible(reason="Thread is not attached yet.")
    public int attachThread(IsolateThread thread) {
        assert (StatusSupport.isStatusCreated(thread)) : "Status should be initialized on creation.";
        OSThreadIdTL.set(thread, this.getCurrentOSThreadId());
        OSThreadHandleTL.set(thread, this.getCurrentOSThreadHandle());
        assert (!ThreadingSupportImpl.isRecurringCallbackRegistered(thread));
        Safepoint.setSafepointRequested(thread, Integer.MAX_VALUE);
        THREAD_MUTEX.lockNoTransition();
        try {
            nextTL.set(thread, head);
            head = thread;
            Heap.getHeap().attachThread(CurrentIsolate.getCurrentThread());
            ActionOnTransitionToJavaSupport.setSynchronizeCode(thread);
            StatusSupport.setStatusNative(thread);
            THREAD_LIST_CONDITION.broadcast();
        }
        finally {
            THREAD_MUTEX.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Manipulates the threads list; broadcasts on changes.")
    public void detachThread(IsolateThread thread) {
        OSThreadHandle threadToCleanup;
        assert (thread.equal((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot detach different thread with this method";
        OSThreadHandle nextOsThreadToCleanup = (OSThreadHandle)WordFactory.nullPointer();
        if (JavaThreads.wasStartedByCurrentIsolate(thread)) {
            nextOsThreadToCleanup = OSThreadHandleTL.get(thread);
        }
        VMThreads.cleanupBeforeDetach(thread);
        VMThreads.setStatusIgnoreSafepointsAndLock();
        try {
            VMThreads.detachThreadInSafeContext(thread);
            threadToCleanup = detachedOsThreadToCleanup.getAndSet(nextOsThreadToCleanup);
            VMThreads.releaseThread(thread);
        }
        finally {
            THREAD_MUTEX.unlock();
        }
        this.cleanupExitedOsThread(threadToCleanup);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    @NeverInline(value="Prevent that anything floats between setting the status and acquiring the mutex.")
    private static void setStatusIgnoreSafepointsAndLock() {
        StatusSupport.setStatusIgnoreSafepoints();
        THREAD_MUTEX.lockNoTransition();
    }

    @Uninterruptible(reason="Isolate thread will be freed.", calleeMustBe=false)
    private static void releaseThread(IsolateThread thread) {
        THREAD_MUTEX.guaranteeIsOwner("This mutex must be locked to prevent that a GC is triggered while detaching a thread from the heap");
        Heap.getHeap().detachThread(thread);
        VMThreads.singleton().freeIsolateThread(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected void cleanupExitedOsThreads() {
        OSThreadHandle threadToCleanup = detachedOsThreadToCleanup.getAndSet((OSThreadHandle)WordFactory.nullPointer());
        this.cleanupExitedOsThread(threadToCleanup);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private void cleanupExitedOsThread(OSThreadHandle threadToCleanup) {
        if (threadToCleanup.isNonNull()) {
            this.joinNoTransition(threadToCleanup);
        }
    }

    @Uninterruptible(reason="Manipulates the threads list; broadcasts on changes.")
    private static void detachThreadInSafeContext(IsolateThread thread) {
        VMThreads.detachJavaThread(thread);
        VMThreads.removeFromThreadList(thread);
        THREAD_LIST_CONDITION.broadcast();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private static void removeFromThreadList(IsolateThread thread) {
        IsolateThread previous = (IsolateThread)WordFactory.nullPointer();
        IsolateThread current = head;
        while (current.isNonNull()) {
            IsolateThread next = nextTL.get(current);
            if (current == thread) {
                if (previous.isNull()) {
                    head = next;
                    break;
                }
                nextTL.set(previous, next);
                break;
            }
            previous = current;
            current = next;
        }
    }

    public void tearDown() {
        ThreadingSupportImpl.pauseRecurringCallback("Execution of arbitrary code is prohibited while/after shutting down the VM operation thread.");
        if (SubstrateOptions.UseDedicatedVMOperationThread.getValue().booleanValue()) {
            VMOperationControl.shutdownAndDetachVMOperationThread();
        }
        this.waitUntilLastOsThreadExited();
    }

    @Uninterruptible(reason="Called from uninterruptible code during teardown.")
    private void waitUntilLastOsThreadExited() {
        this.cleanupExitedOsThreads();
    }

    @Uninterruptible(reason="For calling interruptible code from uninterruptible code.", calleeMustBe=false)
    private static void detachJavaThread(IsolateThread thread) {
        JavaThreads.detachThread(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code, but still safe at this point.", calleeMustBe=false, mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Still safe at this point.")
    private static void cleanupBeforeDetach(IsolateThread thread) {
        JavaThreads.cleanupBeforeDetach(thread);
    }

    public void detachThreads(IsolateThread[] threads) {
        JavaVMOperation.enqueueBlockingSafepoint("detachThreads", () -> {
            for (IsolateThread thread : threads) {
                VMError.guarantee(!JavaThreads.wasStartedByCurrentIsolate(thread), "DetachThreads must not be called for threads that detach themselves automatically.");
                assert (!thread.equal((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot detach current thread with this method";
                VMThreads.cleanupBeforeDetach(thread);
                VMThreads.detachThreadInSafeContext(thread);
                VMThreads.releaseThread(thread);
            }
        });
    }

    public void detachAllThreadsExceptCurrentWithoutCleanupForTearDown() {
        JavaVMOperation.enqueueBlockingSafepoint("detachAllThreadsExceptCurrent", () -> {
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                Thread javaThread;
                IsolateThread next = VMThreads.nextThread(thread);
                if (thread.notEqual((ComparableWord)currentThread) && !JavaThreads.wasStartedByCurrentIsolate(javaThread = JavaThreads.fromVMThread(thread))) {
                    VMThreads.detachThreadInSafeContext(thread);
                }
                thread = next;
            }
        });
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected abstract void joinNoTransition(OSThreadHandle var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract OSThreadHandle getCurrentOSThreadHandle();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract OSThreadId getCurrentOSThreadId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public IsolateThread findIsolateThreadForCurrentOSThread(boolean inCrashHandler) {
        boolean needsLock;
        OSThreadId osThreadId = this.getCurrentOSThreadId();
        boolean bl = needsLock = !inCrashHandler;
        if (needsLock) {
            THREAD_MUTEX.lockNoTransitionUnspecifiedOwner();
        }
        try {
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull() && OSThreadIdTL.get(thread).notEqual((ComparableWord)osThreadId)) {
                thread = VMThreads.nextThread(thread);
            }
            IsolateThread isolateThread = thread;
            return isolateThread;
        }
        finally {
            if (needsLock) {
                THREAD_MUTEX.unlockNoTransitionUnspecifiedOwner();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guaranteeOwnsThreadMutex(String message) {
        THREAD_MUTEX.guaranteeIsOwner(message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean ownsThreadMutex() {
        return THREAD_MUTEX.isOwner();
    }

    static {
        detachedOsThreadToCleanup = new UninterruptibleUtils.AtomicWord();
        nextTL = FastThreadLocalFactory.createWord();
        OSThreadIdTL = FastThreadLocalFactory.createWord();
        OSThreadHandleTL = FastThreadLocalFactory.createWord();
        IsolateTL = FastThreadLocalFactory.createWord();
        initializationState = new UninterruptibleUtils.AtomicInteger(1);
    }

    public static interface OSThreadId
    extends PointerBase {
    }

    public static interface OSThreadHandle
    extends PointerBase {
    }

    public static class ActionOnTransitionToJavaSupport {
        private static final FastThreadLocalInt actionTL = FastThreadLocalFactory.createInt();
        private static final int NO_ACTION = 0;
        private static final int SYNCHRONIZE_CODE = 1;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @ForceFixedRegisterReads
        public static boolean isActionPending() {
            return actionTL.getVolatile() != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @ForceFixedRegisterReads
        public static boolean isSynchronizeCode() {
            return actionTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @ForceFixedRegisterReads
        public static void clearActions() {
            actionTL.setVolatile(0);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @ForceFixedRegisterReads
        public static void setSynchronizeCode(IsolateThread vmThread) {
            assert (StatusSupport.isStatusCreated(vmThread) || VMOperation.isInProgressAtSafepoint()) : "Invariant to avoid races between setting and clearing.";
            actionTL.setVolatile(vmThread, 1);
        }

        public static void requestAllThreadsSynchronizeCode() {
            IsolateThread myself = CurrentIsolate.getCurrentThread();
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (myself != vmThread) {
                    ActionOnTransitionToJavaSupport.setSynchronizeCode(vmThread);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
    }

    public static class StatusSupport {
        public static final FastThreadLocalInt statusTL = FastThreadLocalFactory.createInt();
        private static final FastThreadLocalInt safepointsDisabledTL = FastThreadLocalFactory.createInt();
        public static final int STATUS_ILLEGAL = -1;
        public static final int STATUS_CREATED = 0;
        public static final int STATUS_IN_JAVA = 1;
        public static final int STATUS_IN_SAFEPOINT = 2;
        public static final int STATUS_IN_NATIVE = 3;
        public static final int STATUS_IN_VM = 4;
        private static final int MAX_STATUS = 4;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static String statusToString(int status, boolean safepointsDisabled) {
            switch (status) {
                case 0: {
                    return safepointsDisabled ? "STATUS_CREATED (safepoints disabled)" : "STATUS_CREATED";
                }
                case 1: {
                    return safepointsDisabled ? "STATUS_IN_JAVA (safepoints disabled)" : "STATUS_IN_JAVA";
                }
                case 2: {
                    return safepointsDisabled ? "STATUS_IN_SAFEPOINT (safepoints disabled)" : "STATUS_IN_SAFEPOINT";
                }
                case 3: {
                    return safepointsDisabled ? "STATUS_IN_NATIVE (safepoints disabled)" : "STATUS_IN_NATIVE";
                }
                case 4: {
                    return safepointsDisabled ? "STATUS_IN_VM (safepoints disabled)" : "STATUS_IN_VM";
                }
            }
            return "STATUS error";
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static String getStatusString(IsolateThread vmThread) {
            return StatusSupport.statusToString(statusTL.getVolatile(vmThread), StatusSupport.isStatusIgnoreSafepoints(vmThread));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getStatusVolatile(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getStatusVolatile() {
            return statusTL.getVolatile();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative() {
            statusTL.setVolatile(3);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative(IsolateThread vmThread) {
            statusTL.setVolatile(vmThread, 3);
        }

        public static boolean compareAndSetNativeToSafepoint(IsolateThread vmThread) {
            return statusTL.compareAndSet(vmThread, 3, 2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusJavaUnguarded() {
            statusTL.setVolatile(1);
        }

        public static void setStatusVM() {
            statusTL.setVolatile(4);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @ForceFixedRegisterReads
        public static boolean compareAndSetNativeToNewStatus(int newStatus) {
            return statusTL.compareAndSet(3, newStatus);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusCreated(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread) == 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusNativeOrSafepoint(IsolateThread vmThread) {
            int status = statusTL.getVolatile(vmThread);
            return status == 3 || status == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusNativeOrSafepoint() {
            int status = statusTL.getVolatile();
            return status == 3 || status == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusJava() {
            return statusTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusIgnoreSafepoints(IsolateThread vmThread) {
            return safepointsDisabledTL.getVolatile(vmThread) == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusIgnoreSafepoints() {
            safepointsDisabledTL.setVolatile(1);
        }

        public static boolean isValidStatus(int status) {
            return status > -1 && status <= 4;
        }

        public static int getNewThreadStatus(CFunction.Transition transition) {
            switch (transition) {
                case NO_TRANSITION: {
                    return -1;
                }
                case TO_NATIVE: {
                    return 3;
                }
            }
            throw VMError.shouldNotReachHere("Unknown transition type " + transition);
        }

        public static int getNewThreadStatus(CFunctionOptions.Transition transition) {
            switch (transition) {
                case TO_VM: {
                    return 4;
                }
            }
            throw VMError.shouldNotReachHere("Unknown transition type " + (Object)((Object)transition));
        }
    }
}

