/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class PosixDirectives
implements CContext.Directives {
    private static final String[] commonLibs = new String[]{"<dlfcn.h>", "<fcntl.h>", "<limits.h>", "<locale.h>", "<pthread.h>", "<pwd.h>", "<signal.h>", "<sys/errno.h>", "<sys/mman.h>", "<sys/resource.h>", "<sys/stat.h>", "<sys/time.h>", "<sys/times.h>", "<sys/utsname.h>", "<time.h>", "<unistd.h>"};
    private static final String[] darwinLibs = new String[]{"<CoreFoundation/CoreFoundation.h>", "<mach/mach.h>", "<mach/mach_time.h>", "<mach-o/dyld.h>", "<sys/sysctl.h>", "<sys/syslimits.h>"};
    private static final String[] linuxLibs = new String[]{"<mntent.h>", "<paths.h>"};

    public boolean isInConfiguration() {
        return Platform.includedIn(InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class) || Platform.includedIn(InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class);
    }

    public List<String> getHeaderFiles() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(commonLibs));
        if (Platform.includedIn(InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class)) {
            result.addAll(Arrays.asList(linuxLibs));
        } else if (Platform.includedIn(InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class)) {
            result.addAll(Arrays.asList(darwinLibs));
        } else {
            throw VMError.shouldNotReachHere("Unsupported OS");
        }
        return result;
    }

    public List<String> getMacroDefinitions() {
        return Arrays.asList("_GNU_SOURCE", "_LARGEFILE64_SOURCE");
    }
}

