/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class DarwinUContextRegisterDumper
implements UContextRegisterDumper {
    DarwinUContextRegisterDumper() {
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext) {
        Signal.MContext64 sigcontext = uContext.uc_mcontext64();
        log.indent(true);
        long spValue = DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rsp_offset());
        long ipValue = DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rip_offset());
        log.newline().string("General Purpose Register Set Values: ").newline();
        log.indent(true);
        log.string("RAX ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rax_offset())).newline();
        log.string("RBX ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rbx_offset())).newline();
        log.string("RCX ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rcx_offset())).newline();
        log.string("RDX ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rdx_offset())).newline();
        log.string("RBP ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rbx_offset())).newline();
        log.string("RSI ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rsi_offset())).newline();
        log.string("RDI ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.rdi_offset())).newline();
        log.string("RSP ").zhex(spValue).newline();
        log.string("R8 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r8_offset())).newline();
        log.string("R9 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r9_offset())).newline();
        log.string("R10 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r10_offset())).newline();
        log.string("R11 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r11_offset())).newline();
        log.string("R12 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r12_offset())).newline();
        log.string("R13 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r13_offset())).newline();
        log.string("R14 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r14_offset())).newline();
        log.string("R15 ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r15_offset())).newline();
        log.string("EFL ").zhex(DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.efl_offset())).newline();
        log.string("RIP ").zhex(ipValue).newline();
        log.indent(false);
        SubstrateUtil.printDiagnostics(log, (Pointer)WordFactory.pointer((long)spValue), (CodePointer)WordFactory.pointer((long)ipValue));
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    private static long readRegisterAt(Signal.MContext64 sigcontext, int i) {
        return ((CLongPointer)((CCharPointer)sigcontext).addressOf(i)).read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.MContext64 sigcontext = uContext.uc_mcontext64();
        return WordFactory.pointer((long)DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r14_offset()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.MContext64 sigcontext = uContext.uc_mcontext64();
        return WordFactory.pointer((long)DarwinUContextRegisterDumper.readRegisterAt(sigcontext, sigcontext.r15_offset()));
    }
}

