/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.darwin.DarwinVirtualMemory;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class DarwinImageHeapProvider
implements ImageHeapProvider {
    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(Pointer reservedAddressSpace, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        Pointer heap;
        int imageHeapOffsetInAddressSpace = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        Word imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get();
        Word imageHeapSizeInFile = Isolates.IMAGE_HEAP_END.get().subtract(imageHeapBegin);
        int task = DarwinVirtualMemory.mach_task_self();
        Pointer allocatedMemory = (Pointer)WordFactory.nullPointer();
        if (reservedAddressSpace.isNull()) {
            assert (imageHeapOffsetInAddressSpace == 0);
            WordPointer targetPointer = (WordPointer)StackValue.get(WordPointer.class);
            if (DarwinVirtualMemory.vm_allocate(task, targetPointer, (UnsignedWord)imageHeapSizeInFile, true) != 0) {
                return 8;
            }
            heap = allocatedMemory = (Pointer)targetPointer.read();
        } else {
            Word requiredReservedSize = imageHeapSizeInFile.add(imageHeapOffsetInAddressSpace);
            if (reservedSize.belowThan((UnsignedWord)requiredReservedSize)) {
                return 8;
            }
            Pointer mappedImageHeapBegin = reservedAddressSpace.add(imageHeapOffsetInAddressSpace);
            heap = VirtualMemoryProvider.get().commit((PointerBase)mappedImageHeapBegin, (UnsignedWord)imageHeapSizeInFile, 3);
        }
        if (DarwinVirtualMemory.vm_copy(task, (WordBase)imageHeapBegin, (UnsignedWord)imageHeapSizeInFile, (WordBase)heap) != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 8;
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        UnsignedWord writableBeginPageOffset = UnsignedUtils.roundDown((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get().subtract(imageHeapBegin), pageSize);
        if (writableBeginPageOffset.aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)heap, writableBeginPageOffset, 1) != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 9;
        }
        UnsignedWord writableEndPageOffset = UnsignedUtils.roundUp((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract(imageHeapBegin), pageSize);
        if (writableEndPageOffset.belowThan((UnsignedWord)imageHeapSizeInFile)) {
            Pointer afterWritableBoundary = heap.add(writableEndPageOffset);
            Word afterWritableSize = imageHeapSizeInFile.subtract(writableEndPageOffset);
            if (VirtualMemoryProvider.get().protect((PointerBase)afterWritableBoundary, (UnsignedWord)afterWritableSize, 1) != 0) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return 9;
            }
        }
        basePointer.write((WordBase)heap.subtract(imageHeapOffsetInAddressSpace));
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)PointerUtils.roundUp((PointerBase)heap.add((UnsignedWord)imageHeapSizeInFile), pageSize));
        }
        return 0;
    }

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int freeImageHeap(PointerBase imageHeap) {
        if (imageHeap.isNonNull()) {
            assert (Heap.getHeap().getImageHeapOffsetInAddressSpace() == 0);
            Word imageHeapSizeInFile = Isolates.IMAGE_HEAP_END.get().subtract(Isolates.IMAGE_HEAP_BEGIN.get());
            if (DarwinVirtualMemory.vm_deallocate(DarwinVirtualMemory.mach_task_self(), (WordBase)imageHeap, (UnsignedWord)imageHeapSizeInFile) != 0) {
                return 8;
            }
        }
        return 0;
    }
}

