/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.amd64;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class AMD64UContextRegisterDumper
implements UContextRegisterDumper {
    AMD64UContextRegisterDumper() {
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        long spValue = gregs.read(Signal.GregEnum.REG_RSP.getCValue());
        long ipValue = gregs.read(Signal.GregEnum.REG_RIP.getCValue());
        log.newline().string("General Purpose Register Set Values: ").newline();
        log.indent(true);
        log.string("RAX ").zhex(gregs.read(Signal.GregEnum.REG_RAX.getCValue())).newline();
        log.string("RBX ").zhex(gregs.read(Signal.GregEnum.REG_RBX.getCValue())).newline();
        log.string("RCX ").zhex(gregs.read(Signal.GregEnum.REG_RCX.getCValue())).newline();
        log.string("RDX ").zhex(gregs.read(Signal.GregEnum.REG_RDX.getCValue())).newline();
        log.string("RBP ").zhex(gregs.read(Signal.GregEnum.REG_RBP.getCValue())).newline();
        log.string("RSI ").zhex(gregs.read(Signal.GregEnum.REG_RSI.getCValue())).newline();
        log.string("RDI ").zhex(gregs.read(Signal.GregEnum.REG_RDI.getCValue())).newline();
        log.string("RSP ").zhex(spValue).newline();
        log.string("R8 ").zhex(gregs.read(Signal.GregEnum.REG_R8.getCValue())).newline();
        log.string("R9 ").zhex(gregs.read(Signal.GregEnum.REG_R9.getCValue())).newline();
        log.string("R10 ").zhex(gregs.read(Signal.GregEnum.REG_R10.getCValue())).newline();
        log.string("R11 ").zhex(gregs.read(Signal.GregEnum.REG_R11.getCValue())).newline();
        log.string("R12 ").zhex(gregs.read(Signal.GregEnum.REG_R12.getCValue())).newline();
        log.string("R13 ").zhex(gregs.read(Signal.GregEnum.REG_R13.getCValue())).newline();
        log.string("R14 ").zhex(gregs.read(Signal.GregEnum.REG_R14.getCValue())).newline();
        log.string("R15 ").zhex(gregs.read(Signal.GregEnum.REG_R15.getCValue())).newline();
        log.string("EFL ").zhex(gregs.read(Signal.GregEnum.REG_EFL.getCValue())).newline();
        log.string("RIP ").zhex(ipValue).newline();
        log.indent(false);
        SubstrateUtil.printDiagnostics(log, (Pointer)WordFactory.pointer((long)spValue), (CodePointer)WordFactory.pointer((long)ipValue));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true, calleeMustBe=false)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(AMD64UContextRegisterDumper.getHeapBaseRegister().getCValue()));
    }

    @Fold
    static Signal.GregEnum getHeapBaseRegister() {
        VMError.guarantee(AMD64.r14.equals((Object)SubstrateAMD64RegisterConfig.HEAP_BASE_REGISTER_CANDIDATE));
        return Signal.GregEnum.REG_R14;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true, calleeMustBe=false)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(AMD64UContextRegisterDumper.getThreadPointerRegister().getCValue()));
    }

    @Fold
    static Signal.GregEnum getThreadPointerRegister() {
        VMError.guarantee(AMD64.r15.equals((Object)SubstrateAMD64RegisterConfig.THREAD_REGISTER_CANDIDATE));
        return Signal.GregEnum.REG_R15;
    }
}

