/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.aarch64;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.aarch64.AArch64;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class AArch64UContextRegisterDumper
implements UContextRegisterDumper {
    AArch64UContextRegisterDumper() {
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext) {
        Signal.mcontext_t sigcontext = uContext.uc_mcontext();
        Signal.GregsPointer regs = sigcontext.regs();
        long spValue = sigcontext.sp();
        long pcValue = sigcontext.pc();
        log.newline().string("General Purpose Register Set Values: ").newline();
        log.indent(true);
        log.string("R0 ").zhex(regs.read(0)).newline();
        log.string("R1 ").zhex(regs.read(1)).newline();
        log.string("R2 ").zhex(regs.read(2)).newline();
        log.string("R3 ").zhex(regs.read(3)).newline();
        log.string("R4 ").zhex(regs.read(4)).newline();
        log.string("R5 ").zhex(regs.read(5)).newline();
        log.string("R6 ").zhex(regs.read(6)).newline();
        log.string("R7 ").zhex(regs.read(7)).newline();
        log.string("R8 ").zhex(regs.read(8)).newline();
        log.string("R9 ").zhex(regs.read(9)).newline();
        log.string("R10 ").zhex(regs.read(10)).newline();
        log.string("R11 ").zhex(regs.read(11)).newline();
        log.string("R12 ").zhex(regs.read(12)).newline();
        log.string("R13 ").zhex(regs.read(13)).newline();
        log.string("R14 ").zhex(regs.read(14)).newline();
        log.string("R15 ").zhex(regs.read(15)).newline();
        log.string("R16 ").zhex(regs.read(16)).newline();
        log.string("R17 ").zhex(regs.read(17)).newline();
        log.string("R18 ").zhex(regs.read(18)).newline();
        log.string("R19 ").zhex(regs.read(19)).newline();
        log.string("R20 ").zhex(regs.read(20)).newline();
        log.string("R21 ").zhex(regs.read(21)).newline();
        log.string("R22 ").zhex(regs.read(22)).newline();
        log.string("R23 ").zhex(regs.read(23)).newline();
        log.string("R24 ").zhex(regs.read(24)).newline();
        log.string("R25 ").zhex(regs.read(25)).newline();
        log.string("R26 ").zhex(regs.read(26)).newline();
        log.string("R27 ").zhex(regs.read(27)).newline();
        log.string("R28 ").zhex(regs.read(28)).newline();
        log.string("R29 ").zhex(regs.read(29)).newline();
        log.string("R30 ").zhex(regs.read(30)).newline();
        log.string("R31 ").zhex(regs.read(31)).newline();
        log.string("SP ").zhex(spValue).newline();
        log.string("PC ").zhex(pcValue).newline();
        log.indent(false);
        SubstrateUtil.printDiagnostics(log, (Pointer)WordFactory.pointer((long)spValue), (CodePointer)WordFactory.pointer((long)pcValue));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.mcontext_t sigcontext = uContext.uc_mcontext();
        Signal.GregsPointer regs = sigcontext.regs();
        return WordFactory.pointer((long)regs.read(AArch64UContextRegisterDumper.getHeapBaseRegisterNumber()));
    }

    @Fold
    static int getHeapBaseRegisterNumber() {
        VMError.guarantee(AArch64.r27.equals((Object)SubstrateAArch64RegisterConfig.HEAP_BASE_REGISTER_CANDIDATE));
        return 27;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.mcontext_t sigcontext = uContext.uc_mcontext();
        Signal.GregsPointer regs = sigcontext.regs();
        return WordFactory.pointer((long)regs.read(AArch64UContextRegisterDumper.getThreadPointerRegisterNumber()));
    }

    @Fold
    static int getThreadPointerRegisterNumber() {
        VMError.guarantee(AArch64.r28.equals((Object)SubstrateAArch64RegisterConfig.THREAD_REGISTER_CANDIDATE));
        return 28;
    }
}

