/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class SubstrateSegfaultHandler {
    private static volatile boolean dispatchInProgress = false;
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(SubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    SubstrateSegfaultHandler() {
    }

    @Fold
    static boolean fixedRegisters() {
        return !SubstrateOptions.CompilerBackend.getValue().equals("llvm");
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (SubstrateSegfaultHandler.fixedRegisters()) {
            Isolate isolate;
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                PointerBase heapBase = ((UContextRegisterDumper)ImageSingletons.lookup(UContextRegisterDumper.class)).getHeapBase(uContext);
                WriteHeapBaseNode.writeCurrentVMHeapBase(heapBase);
            }
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread threadPointer = (IsolateThread)((UContextRegisterDumper)ImageSingletons.lookup(UContextRegisterDumper.class)).getThreadPointer(uContext);
                WriteCurrentVMThreadNode.writeCurrentVMThread(threadPointer);
            }
            if (Isolates.checkSanity(isolate = VMThreads.IsolateTL.get()) != 0 || SubstrateOptions.SpawnIsolates.getValue().booleanValue() && VMThreads.IsolateTL.get().notEqual((ComparableWord)KnownIntrinsics.heapBase())) {
                return;
            }
        } else {
            Isolate isolate = (Isolate)CEntryPointSnippets.baseIsolate.get().readWord(0);
            if (isolate.rawValue() == -1L) {
                return;
            }
            CEntryPointActions.enterIsolateFromCrashHandler(isolate);
        }
        SubstrateSegfaultHandler.dump(signalNumber, uContext);
    }

    @Uninterruptible(reason="Called from uninterruptible method", calleeMustBe=false)
    private static void dump(int signalNumber, Signal.ucontext_t uContext) {
        if (dispatchInProgress) {
            Log.log().newline().string("[ [ SubstrateSegfaultHandler already handling signal ").signed(signalNumber).string(" ] ]").newline();
            return;
        }
        dispatchInProgress = true;
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        Log log = Log.log();
        log.autoflush(true);
        log.string("[ [ SubstrateSegfaultHandler caught signal ").signed(signalNumber).string(" ] ]").newline();
        ((UContextRegisterDumper)ImageSingletons.lookup(UContextRegisterDumper.class)).dumpRegisters(log, uContext);
        log.string("Use runtime option -R:-InstallSegfaultHandler if you don't want to use SubstrateSegfaultHandler.").newline();
        log.newline().string("Bye bye ...").newline().newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    static void install() {
        Boolean optionValue = Options.InstallSegfaultHandler.getValue();
        if (optionValue == Boolean.TRUE || optionValue == null && ImageInfo.isExecutable()) {
            int structSigActionSize = SizeOf.get(Signal.sigaction.class);
            Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
            LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
            structSigAction.sa_flags(Signal.SA_SIGINFO());
            structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
            Signal.sigaction(Signal.SignalEnum.SIGSEGV, structSigAction, (Signal.sigaction)WordFactory.nullPointer());
        }
    }

    public static class Options {
        @Option(help={"Install segfault handler that prints register contents and full Java stacktrace. Default: enabled for an executable, disabled for a shared library."})
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Object>(null);
    }
}

