/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.TimeZoneSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.Arrays;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class TimeZoneFeature
implements Feature {
    TimeZoneFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        String[] supportedZoneIDs = Options.IncludeAllTimeZones.getValue() != false ? TimeZone.getAvailableIDs() : Options.IncludeTimeZones.getValue();
        Map<String, TimeZone> supportedZones = Arrays.stream(supportedZoneIDs).map(TimeZone::getTimeZone).collect(Collectors.toMap(TimeZone::getID, tz -> tz, (tz1, tz2) -> tz1));
        ImageSingletons.add(TimeZoneSupport.class, (Object)new TimeZoneSupport(supportedZones, Options.defaultZone));
    }

    static class Options {
        private static final TimeZone defaultZone = TimeZone.getDefault();
        @Option(help={"When true, all time zones will be pre-initialized in the image."})
        public static final HostedOptionKey<Boolean> IncludeAllTimeZones = new HostedOptionKey<Boolean>(false);
        @Option(help={"The time zones, in addition to the default zone of the host, that will be pre-initialized in the image."})
        public static final HostedOptionKey<String[]> IncludeTimeZones = new HostedOptionKey<String[]>(new String[]{"GMT", "UTC", defaultZone.getID()});

        Options() {
        }
    }
}

