/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.MonitorSupport;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Object.class)
final class Target_java_lang_Object {
    Target_java_lang_Object() {
    }

    @Substitute
    @TargetElement(name="registerNatives", onlyWith={JDK11OrEarlier.class})
    private static void registerNativesSubst() {
    }

    @Substitute
    @TargetElement(name="getClass")
    private Object getClassSubst() {
        return KnownIntrinsics.readHub(this);
    }

    @Substitute
    @TargetElement(name="hashCode")
    private int hashCodeSubst() {
        return System.identityHashCode(this);
    }

    @Substitute
    @TargetElement(name="toString")
    private String toStringSubst() {
        return this.getClass().getName() + "@" + Long.toHexString(Word.objectToUntrackedPointer((Object)this).rawValue());
    }

    @Substitute
    @TargetElement(name="wait")
    private void waitSubst(long timeoutMillis) throws InterruptedException {
        ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).wait(this, timeoutMillis);
    }

    @Substitute
    @TargetElement(name="notify")
    private void notifySubst() {
        ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).notify(this, false);
    }

    @Substitute
    @TargetElement(name="notifyAll")
    private void notifyAllSubst() {
        ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).notify(this, true);
    }
}

