/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import java.lang.management.MemoryMXBean;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.spi.GCProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public abstract class Heap {
    @Fold
    public static Heap getHeap() {
        return (Heap)ImageSingletons.lookup(Heap.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected Heap() {
    }

    @Uninterruptible(reason="Called during startup.")
    public abstract void attachThread(IsolateThread var1);

    public abstract void detachThread(IsolateThread var1);

    public abstract void suspendAllocation();

    public abstract void resumeAllocation();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isAllocationDisallowed();

    public abstract GC getGC();

    public abstract boolean walkObjects(ObjectVisitor var1);

    public abstract boolean walkImageHeapObjects(ObjectVisitor var1);

    public abstract boolean walkCollectedHeapObjects(ObjectVisitor var1);

    public abstract List<Class<?>> getClassList();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract ObjectHeader getObjectHeader();

    public abstract MemoryMXBean getMemoryMXBean();

    @Uninterruptible(reason="Tear-down in progress.")
    public abstract boolean tearDown();

    public abstract void prepareForSafepoint();

    public abstract void endSafepoint();

    public abstract GCProvider getGCProvider();

    @Fold
    public abstract int getImageHeapOffsetInAddressSpace();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isInImageHeap(Object var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isInImageHeap(Pointer var1);
}

