/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.heap.FeebleReference;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.TimeUtils;

@UnknownClass
public final class FeebleReferenceList<T> {
    private final UninterruptibleUtils.AtomicReference<FeebleReference<? extends T>> head = new UninterruptibleUtils.AtomicReference<Object>(null);
    private static final VMMutex REF_MUTEX = new VMMutex();
    private static final VMCondition REF_CONDITION = new VMCondition(REF_MUTEX);
    private static final InterruptedException preallocatedInterruptedException = new InterruptedException();

    public static <T> FeebleReferenceList<T> factory() {
        return new FeebleReferenceList<T>();
    }

    private FeebleReferenceList() {
    }

    public boolean isEmpty() {
        return this.getHead() == null;
    }

    public boolean push(FeebleReference<?> fr) {
        FeebleReferenceList<?> clearedList = fr.clearList();
        if (clearedList != null) {
            FeebleReference<T> sampleHead;
            assert (clearedList == this) : "Pushing to the wrong list.";
            assert (!fr.isEnlisted()) : "Pushing a FeebleReference that is already on a list.";
            do {
                sampleHead = this.getHead();
                fr.listPrepend(sampleHead);
            } while (!this.compareAndSetHead(sampleHead, FeebleReference.uncheckedNarrow(fr)));
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="List is pushed to during collections.")
    public FeebleReference<? extends T> pop() {
        FeebleReference<T> result;
        block1: {
            FeebleReference<T> sampleNext;
            FeebleReference<T> sampleHead;
            do {
                if ((sampleHead = this.getHead()) != null) continue;
                result = null;
                break block1;
            } while (!this.compareAndSetHead(sampleHead, sampleNext = sampleHead.listGetNext()));
            result = sampleHead;
            FeebleReferenceList.clean(result);
        }
        return result;
    }

    public FeebleReference<? extends T> remove(long timeoutMillis) throws IllegalArgumentException, InterruptedException {
        FeebleReference<T> result;
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("FeebleReferenceList.remove: Negative timeout.");
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMOperation.guaranteeNotInProgress("Calling FeebleReferenceList.remove inside a VMOperation would block.");
            long timeoutNanos = TimeUtils.millisToNanos(timeoutMillis);
            result = this.popWithBlocking(timeoutNanos);
        } else {
            result = this.pop();
        }
        return result;
    }

    private FeebleReference<? extends T> popWithBlocking(long timeoutNanos) throws InterruptedException {
        long remainingNanos = timeoutNanos;
        while (true) {
            FeebleReference<T> result;
            if ((result = this.pop()) != null) {
                return result;
            }
            if (Thread.interrupted()) {
                throw preallocatedInterruptedException;
            }
            if (timeoutNanos == 0L) {
                FeebleReferenceList.await();
                continue;
            }
            if ((remainingNanos = FeebleReferenceList.await(remainingNanos)) <= 0L) break;
        }
        return null;
    }

    public FeebleReference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FeebleReference<? extends T> getHead() {
        return this.head.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean compareAndSetHead(FeebleReference<? extends T> expect, FeebleReference<? extends T> update) {
        return this.head.compareAndSet(expect, update);
    }

    private static void await() {
        Thread thread = Thread.currentThread();
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 657);
        try {
            FeebleReferenceList.awaitWithTransition();
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long await(long waitNanos) {
        Thread thread = Thread.currentThread();
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 673);
        try {
            long l = FeebleReferenceList.awaitWithTransition(waitNanos);
            return l;
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static void awaitWithTransition() {
        CFunctionPrologueNode.cFunctionPrologue(3);
        FeebleReferenceList.awaitInNative();
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static long awaitWithTransition(long waitNanos) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        long result = FeebleReferenceList.awaitInNative(waitNanos);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
        return result;
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void awaitInNative() {
        REF_MUTEX.lockNoTransition();
        try {
            REF_CONDITION.blockNoTransition();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static long awaitInNative(long waitNanos) {
        long result = waitNanos;
        REF_MUTEX.lockNoTransition();
        try {
            result = REF_CONDITION.blockNoTransition(waitNanos);
        }
        finally {
            REF_MUTEX.unlock();
        }
        return result;
    }

    @Uninterruptible(reason="No GC is allowed while holding the lock - otherwise the application and the GC could deadlock.")
    public static void interruptWaiters() {
        REF_MUTEX.lockNoTransition();
        try {
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    public static void signalWaiters() {
        assert (VMOperation.isInProgressAtSafepoint()) : "must only be called by the GC";
        REF_MUTEX.lock();
        try {
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static void clean(FeebleReference<?> fr) {
        fr.listRemove();
    }
}

