/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

public class DeoptTester {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DEOPTTEST = SnippetRuntime.findForeignCall(DeoptTester.class, "deoptTest", false, LocationIdentity.any());
    private static final Set<Long> handledPCs = new HashSet<Long>();
    private static int inDeoptTest;
    private static final StackFrameVisitor collectPcVisitor;

    @Fold
    public static boolean enabled() {
        boolean result = Options.DeoptimizeAll.getValue();
        if (result) {
            VMError.guarantee(DeoptimizationSupport.enabled(), "Enabling DeoptimizeAll also requires enabling deoptimization support");
        }
        return result;
    }

    @NeverInline(value="deoptTest must have a separate stack frame")
    @SubstrateForeignCallTarget(stubCallingConvention=true)
    public static void deoptTest() {
        assert (DeoptTester.enabled());
        if (inDeoptTest > 0) {
            return;
        }
        ++inDeoptTest;
        try {
            if (Heap.getHeap().isAllocationDisallowed()) {
                return;
            }
            if (!CEntryPointSnippets.isIsolateInitialized()) {
                return;
            }
            if (ThreadingSupportImpl.isRecurringCallbackPaused()) {
                return;
            }
            if (VMOperation.isInProgress()) {
                return;
            }
            Pointer startSp = KnownIntrinsics.readCallerStackPointer();
            int numHandledPCs = handledPCs.size();
            JavaStackWalker.walkCurrentThread(startSp, collectPcVisitor);
            if (handledPCs.size() > numHandledPCs) {
                Deoptimizer.deoptimizeAll();
            }
        }
        finally {
            --inDeoptTest;
        }
    }

    public static void disableDeoptTesting() {
        if (DeoptTester.enabled()) {
            ++inDeoptTest;
        }
    }

    public static void enableDeoptTesting() {
        if (DeoptTester.enabled()) {
            --inDeoptTest;
        }
    }

    static {
        collectPcVisitor = new StackFrameVisitor(){

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Only deals with IPs, not Objects.")
            public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
                handledPCs.add(ip.rawValue());
                return true;
            }
        };
    }

    public static class Options {
        @Option(help={"Compiles all methods as deoptimization targets for testing"})
        public static final HostedOptionKey<Boolean> DeoptimizeAll = new HostedOptionKey<Boolean>(false);
    }
}

