/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.meta.SubstrateBasicLoweringProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.nodes.CodeSynchronizationNode;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.amd64.AMD64LoweringProviderMixin;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOfDispatchNode;

public class SubstrateAMD64LoweringProvider
extends SubstrateBasicLoweringProvider
implements AMD64LoweringProviderMixin {
    public SubstrateAMD64LoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, TargetDescription target) {
        super(metaAccess, foreignCalls, target);
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        NodeLoweringProvider<?> lowering = this.getLowerings().get(n.getClass());
        if (lowering != null) {
            lowering.lower(n, tool);
        } else if (!(n instanceof RemNode)) {
            if (n instanceof CodeSynchronizationNode) {
                CodeSynchronizationNode syncNode = (CodeSynchronizationNode)n;
                syncNode.graph().removeFixed((FixedWithNextNode)syncNode);
            } else if (n instanceof AMD64ArrayIndexOfDispatchNode) {
                this.lowerArrayIndexOf((AMD64ArrayIndexOfDispatchNode)n);
            } else {
                super.lower(n, tool);
            }
        }
    }

    private void lowerArrayIndexOf(AMD64ArrayIndexOfDispatchNode dispatchNode) {
        StructuredGraph graph = dispatchNode.graph();
        ForeignCallNode call = (ForeignCallNode)graph.add((Node)new ForeignCallNode(this.foreignCalls, dispatchNode.getStubCallDescriptor(), dispatchNode.getStubCallArgs()));
        graph.replaceFixed((FixedWithNextNode)dispatchNode, (Node)call);
    }
}

