/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public class FormatArrayNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<FormatArrayNode> TYPE = NodeClass.create(FormatArrayNode.class);
    @Node.Input
    protected ValueNode memory;
    @Node.Input
    protected ValueNode hub;
    @Node.Input
    protected ValueNode length;
    @Node.Input
    protected ValueNode rememberedSet;
    @Node.Input
    protected ValueNode unaligned;
    @Node.Input
    protected ValueNode fillContents;
    @Node.Input
    protected ValueNode emitMemoryBarrier;

    public FormatArrayNode(ValueNode memory, ValueNode hub, ValueNode length, ValueNode rememberedSet, ValueNode unaligned, ValueNode fillContents, ValueNode emitMemoryBarrier) {
        super(TYPE, StampFactory.objectNonNull());
        this.memory = memory;
        this.hub = hub;
        this.length = length;
        this.rememberedSet = rememberedSet;
        this.unaligned = unaligned;
        this.fillContents = fillContents;
        this.emitMemoryBarrier = emitMemoryBarrier;
    }

    public ValueNode getMemory() {
        return this.memory;
    }

    public ValueNode getHub() {
        return this.hub;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public ValueNode getRememberedSet() {
        return this.rememberedSet;
    }

    public ValueNode getUnaligned() {
        return this.unaligned;
    }

    public ValueNode getFillContents() {
        return this.fillContents;
    }

    public ValueNode getEmitMemoryBarrier() {
        return this.emitMemoryBarrier;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    @Node.NodeIntrinsic
    public static native Object formatArray(Pointer var0, Class<?> var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6);
}

