/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippets;
import com.oracle.svm.core.genscavenge.graal.GenScavengeAllocationSnippets;
import com.oracle.svm.core.genscavenge.hosted.LinearImageHeapLayouter;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.jdk.RuntimeFeature;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class HeapFeature
implements GraalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.UseCardRememberedSetHeap.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(RuntimeFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(Heap.class, (Object)new HeapImpl((Feature.FeatureAccess)access));
        ImageSingletons.add(ImageHeapLayouter.class, (Object)new LinearImageHeapLayouter());
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        BarrierSnippets barrierSnippets = BarrierSnippets.factory(options, factories, providers, snippetReflection);
        barrierSnippets.registerLowerings(lowerings);
        GenScavengeAllocationSnippets.registerLowering(options, factories, providers, snippetReflection, lowerings);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        ImageHeapInfo imageHeapInfo = HeapImpl.getImageHeapInfo();
        access.registerAsImmutable((Object)imageHeapInfo);
    }

    @Override
    public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls, boolean hosted) {
        GenScavengeAllocationSnippets.registerForeignCalls(providers, foreignCalls);
    }
}

