/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class ObjectHeaderImpl
extends ObjectHeader {
    private static final UnsignedWord NO_REMEMBERED_SET_ALIGNED = WordFactory.unsigned((int)0);
    private static final UnsignedWord CARD_REMEMBERED_SET_ALIGNED = WordFactory.unsigned((int)1);
    private static final UnsignedWord NO_REMEMBERED_SET_UNALIGNED = WordFactory.unsigned((int)2);
    private static final UnsignedWord CARD_REMEMBERED_SET_UNALIGNED = WordFactory.unsigned((int)3);
    private static final UnsignedWord UNUSED_100 = WordFactory.unsigned((int)4);
    private static final UnsignedWord UNUSED_101 = WordFactory.unsigned((int)5);
    private static final UnsignedWord BOOT_IMAGE = WordFactory.unsigned((int)6);
    private static final UnsignedWord FORWARDED = WordFactory.unsigned((int)7);
    private static final int ALL_RESERVED_BITS = NumUtil.safeToInt((long)FORWARDED.rawValue());
    private static final UnsignedWord MASK_HEADER_BITS = WordFactory.unsigned((int)ALL_RESERVED_BITS);
    private static final UnsignedWord CLEAR_HEADER_BITS = MASK_HEADER_BITS.not();
    private static final UnsignedWord MASK_REMEMBERED_SET = CARD_REMEMBERED_SET_ALIGNED.and(CARD_REMEMBERED_SET_UNALIGNED);
    private static final UnsignedWord MASK_UNALIGNED = NO_REMEMBERED_SET_UNALIGNED.and(CARD_REMEMBERED_SET_UNALIGNED);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ObjectHeaderImpl() {
    }

    @Fold
    public static ObjectHeaderImpl getObjectHeaderImpl() {
        ObjectHeaderImpl oh = HeapImpl.getHeapImpl().getObjectHeaderImpl();
        assert (oh != null);
        return oh;
    }

    @Override
    public int getReservedBitsMask() {
        assert (MASK_HEADER_BITS.rawValue() == (long)ALL_RESERVED_BITS);
        assert (CLEAR_HEADER_BITS.rawValue() == (long)(~ALL_RESERVED_BITS));
        return ALL_RESERVED_BITS;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord readHeaderFromPointer(Pointer objectPointer) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return WordFactory.unsigned((int)objectPointer.readInt(ObjectHeaderImpl.getHubOffset()));
        }
        return (UnsignedWord)objectPointer.readWord(ObjectHeaderImpl.getHubOffset());
    }

    public static UnsignedWord readHeaderFromPointerCarefully(Pointer p) {
        VMError.guarantee(!p.isNull(), "ObjectHeader.readHeaderFromPointerCarefully:  p: null");
        if (!ReferenceAccess.singleton().haveCompressedReferences()) {
            VMError.guarantee(p.notEqual((UnsignedWord)HeapPolicy.getProducedHeapChunkZapWord()), "ObjectHeader.readHeaderFromPointerCarefully:  p: producedZapValue");
            VMError.guarantee(p.notEqual((UnsignedWord)HeapPolicy.getConsumedHeapChunkZapWord()), "ObjectHeader.readHeaderFromPointerCarefully:  p: consumedZapValue");
        }
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(p);
        VMError.guarantee(header.notEqual((UnsignedWord)WordFactory.zero()), "ObjectHeader.readHeaderFromPointerCarefully:  header: 0");
        VMError.guarantee(!ObjectHeaderImpl.isProducedHeapChunkZapped(header), "ObjectHeader.readHeaderFromPointerCarefully:  header: producedZapValue");
        VMError.guarantee(!ObjectHeaderImpl.isConsumedHeapChunkZapped(header), "ObjectHeader.readHeaderFromPointerCarefully:  header: consumedZapValue");
        return header;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord readHeaderFromObject(Object o) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return WordFactory.unsigned((int)ObjectAccess.readInt((Object)o, (int)ObjectHeaderImpl.getHubOffset()));
        }
        return (UnsignedWord)ObjectAccess.readWord((Object)o, (int)ObjectHeaderImpl.getHubOffset());
    }

    public static UnsignedWord readHeaderFromObjectCarefully(Object o) {
        VMError.guarantee(o != null, "ObjectHeader.readHeaderFromObjectCarefully:  o: null");
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObject(o);
        VMError.guarantee(header.notEqual((UnsignedWord)WordFactory.zero()), "ObjectHeader.readHeaderFromObjectCarefully:  header: 0");
        VMError.guarantee(!ObjectHeaderImpl.isProducedHeapChunkZapped(header), "ObjectHeader.readHeaderFromObjectCarefully:  header: producedZapValue");
        VMError.guarantee(!ObjectHeaderImpl.isConsumedHeapChunkZapped(header), "ObjectHeader.readHeaderFromObjectCarefully:  header: consumedZapValue");
        return header;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub readDynamicHubFromPointer(Pointer ptr) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(ptr);
        return this.dynamicHubFromObjectHeader(header);
    }

    public static DynamicHub readDynamicHubFromObjectCarefully(Object o) {
        ObjectHeaderImpl.readHeaderFromObjectCarefully(o);
        return KnownIntrinsics.readHub(o);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub dynamicHubFromObjectHeader(UnsignedWord header) {
        Object objectValue;
        UnsignedWord pointerBits = ObjectHeaderImpl.clearBits(header);
        ReferenceAccess referenceAccess = ReferenceAccess.singleton();
        if (referenceAccess.haveCompressedReferences()) {
            UnsignedWord compressedBits = pointerBits.unsignedShiftRight(ObjectHeaderImpl.getCompressionShift());
            objectValue = referenceAccess.uncompressReference(compressedBits);
        } else {
            objectValue = ((Pointer)pointerBits).toObject();
        }
        return KnownIntrinsics.convertUnknownValue(objectValue, DynamicHub.class);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initializeHeaderOfNewObject(Pointer objectPointer, DynamicHub hub, ObjectHeader.HeapKind heapKind) {
        assert (heapKind == ObjectHeader.HeapKind.Unmanaged);
        Word objectHeader = this.encodeAsObjectHeader(hub, false, false);
        this.initializeHeaderOfNewObject(objectPointer, objectHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initializeHeaderOfNewObject(Pointer objectPointer, Word encodedHub) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            objectPointer.writeInt(ObjectHeaderImpl.getHubOffset(), (int)encodedHub.rawValue(), LocationIdentity.INIT_LOCATION);
        } else {
            objectPointer.writeWord(ObjectHeaderImpl.getHubOffset(), (WordBase)encodedHub, LocationIdentity.INIT_LOCATION);
        }
    }

    private static void writeHeaderToObject(Object o, WordBase header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            ObjectAccess.writeInt((Object)o, (int)ObjectHeaderImpl.getHubOffset(), (int)((int)header.rawValue()));
        } else {
            ObjectAccess.writeWord((Object)o, (int)ObjectHeaderImpl.getHubOffset(), (WordBase)header);
        }
    }

    @Override
    public Word encodeAsTLABObjectHeader(DynamicHub hub) {
        return this.encodeAsObjectHeader(hub, false, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        Word result = Word.objectToUntrackedPointer((Object)hub);
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() && ObjectHeaderImpl.hasBase()) {
            result = result.subtract((UnsignedWord)KnownIntrinsics.heapBase());
        }
        if (rememberedSet) {
            result = result.or(MASK_REMEMBERED_SET);
        }
        if (unaligned) {
            result = result.or(MASK_UNALIGNED);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord clearBits(UnsignedWord header) {
        return header.and(CLEAR_HEADER_BITS);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isProducedHeapChunkZapped(UnsignedWord header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return header.equal(HeapPolicy.getProducedHeapChunkZapInt());
        }
        return header.equal((UnsignedWord)HeapPolicy.getProducedHeapChunkZapWord());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isConsumedHeapChunkZapped(UnsignedWord header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return header.equal(HeapPolicy.getConsumedHeapChunkZapInt());
        }
        return header.equal((UnsignedWord)HeapPolicy.getConsumedHeapChunkZapWord());
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public long encodeAsImageHeapObjectHeader(long heapBaseRelativeAddress) {
        assert ((heapBaseRelativeAddress & MASK_HEADER_BITS.rawValue()) == 0L) : "Object header bits must be zero";
        return heapBaseRelativeAddress | BOOT_IMAGE.rawValue();
    }

    public boolean isBootImageCarefully(Object o) {
        UnsignedWord headerBits = ObjectHeaderImpl.readHeaderBitsFromObjectCarefully(o);
        return ObjectHeaderImpl.isBootImageHeaderBits(headerBits);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean isBootImage(Object o) {
        UnsignedWord headerBits = ObjectHeaderImpl.readHeaderBitsFromObject(o);
        return ObjectHeaderImpl.isBootImageHeaderBits(headerBits);
    }

    public boolean isBootImageHeader(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeader(header);
        return ObjectHeaderImpl.isBootImageHeaderBits(headerBits);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isBootImageHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.headerBitsEqual(headerBits, BOOT_IMAGE);
    }

    public boolean isForwardedHeader(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeader(header);
        return ObjectHeaderImpl.isForwardedHeaderBits(headerBits);
    }

    public boolean isForwardedHeaderCarefully(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeaderCarefully(header);
        return ObjectHeaderImpl.isForwardedHeaderBits(headerBits);
    }

    private static boolean isForwardedHeaderBits(UnsignedWord headerBits) {
        return headerBits.equal(FORWARDED);
    }

    public Pointer getForwardingPointer(Pointer objectPointer) {
        return Word.objectToUntrackedPointer((Object)this.getForwardedObject(objectPointer));
    }

    public Object getForwardedObject(Pointer ptr) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(ptr);
        assert (this.isForwardedHeader(header));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            if (ReferenceAccess.singleton().getCompressEncoding().hasShift()) {
                ObjectLayout layout = ConfigurationValues.getObjectLayout();
                assert (layout.isAligned(ObjectHeaderImpl.getHubOffset()) && 2 * ObjectHeaderImpl.getReferenceSize() <= layout.getAlignment()) : "Forwarding reference must fit after hub";
                int forwardRefOffset = ObjectHeaderImpl.getHubOffset() + ObjectHeaderImpl.getReferenceSize();
                return ReferenceAccess.singleton().readObjectAt(ptr.add(forwardRefOffset), true);
            }
            return ReferenceAccess.singleton().uncompressReference(ObjectHeaderImpl.clearBits(header));
        }
        return ((Pointer)ObjectHeaderImpl.clearBits(header)).toObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isNonHeapAllocatedHeader(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeader(header);
        return ObjectHeaderImpl.isNonHeapAllocatedHeaderBits(headerBits);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isNonHeapAllocatedHeaderBits(UnsignedWord headerBits) {
        return headerBits.equal(BOOT_IMAGE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isNonHeapAllocated(Object o) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObject(o);
        return this.isNonHeapAllocatedHeader(header);
    }

    public boolean isNonHeapAllocatedCarefully(Object o) {
        UnsignedWord headerBits = ObjectHeaderImpl.readHeaderBitsFromObjectCarefully(o);
        return this.isNonHeapAllocatedHeader(headerBits);
    }

    public boolean isHeapAllocated(Object o) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderBitsFromObject(o);
        return ObjectHeaderImpl.isHeapAllocatedHeaderBits(header);
    }

    private static boolean isHeapAllocatedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.isAlignedHeaderBits(headerBits) || ObjectHeaderImpl.isUnalignedHeaderBits(headerBits);
    }

    public boolean isAlignedObject(Object o) {
        UnsignedWord headerBits = ObjectHeaderImpl.readHeaderBitsFromObject(o);
        return ObjectHeaderImpl.isAlignedHeaderBits(headerBits);
    }

    protected boolean isAlignedHeader(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeader(header);
        return ObjectHeaderImpl.isAlignedHeaderBits(headerBits);
    }

    private static boolean isAlignedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.isNoRememberedSetAlignedHeaderBits(headerBits) || ObjectHeaderImpl.isCardRememberedSetAlignedHeaderBits(headerBits);
    }

    private static boolean isNoRememberedSetAlignedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.headerBitsEqual(headerBits, NO_REMEMBERED_SET_ALIGNED);
    }

    private static boolean isCardRememberedSetAlignedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.headerBitsEqual(headerBits, CARD_REMEMBERED_SET_ALIGNED);
    }

    protected void setCardRememberedSetAligned(Object o) {
        ObjectHeaderImpl.setHeaderBitsOnObject(o, CARD_REMEMBERED_SET_ALIGNED);
    }

    protected boolean isUnalignedHeader(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeader(header);
        return ObjectHeaderImpl.isUnalignedHeaderBits(headerBits);
    }

    public boolean isUnalignedObject(Object o) {
        UnsignedWord headerBits = ObjectHeaderImpl.readHeaderBitsFromObject(o);
        return ObjectHeaderImpl.isUnalignedHeaderBits(headerBits);
    }

    private static boolean isUnalignedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.isNoRememberedSetUnalignedHeaderBits(headerBits) || ObjectHeaderImpl.isCardRememberedSetUnalignedHeaderBits(headerBits);
    }

    private static boolean isNoRememberedSetUnalignedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.headerBitsEqual(headerBits, NO_REMEMBERED_SET_UNALIGNED);
    }

    private static boolean isCardRememberedSetUnalignedHeaderBits(UnsignedWord headerBits) {
        return ObjectHeaderImpl.headerBitsEqual(headerBits, CARD_REMEMBERED_SET_UNALIGNED);
    }

    private static void setCardRememberedSetUnaligned(Object o) {
        ObjectHeaderImpl.setHeaderBitsOnObject(o, CARD_REMEMBERED_SET_UNALIGNED);
    }

    public void setUnaligned(Object o) {
        ObjectHeaderImpl.setCardRememberedSetUnaligned(o);
    }

    public static boolean hasRememberedSet(UnsignedWord header) {
        return header.and(MASK_REMEMBERED_SET).notEqual(0);
    }

    public static boolean isHeapObjectUnaligned(UnsignedWord header) {
        return header.and(MASK_UNALIGNED).notEqual(0);
    }

    protected void installForwardingPointer(Object original, Object copy) {
        Word forwardHeader;
        assert (!this.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)original)));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            if (ReferenceAccess.singleton().getCompressEncoding().hasShift()) {
                forwardHeader = WordFactory.unsigned((long)-1085102592571150096L);
                ObjectAccess.writeObject((Object)original, (int)(ObjectHeaderImpl.getHubOffset() + ObjectHeaderImpl.getReferenceSize()), (Object)copy);
            } else {
                forwardHeader = ReferenceAccess.singleton().getCompressedRepresentation(copy);
            }
        } else {
            forwardHeader = Word.objectToUntrackedPointer((Object)copy);
        }
        assert (ObjectHeaderImpl.getHeaderBitsFromHeader((UnsignedWord)forwardHeader).equal(0));
        ObjectHeaderImpl.writeHeaderToObject(original, (WordBase)forwardHeader.or(FORWARDED));
        assert (this.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)original)));
    }

    private boolean isPointerToForwardedObject(Pointer p) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(p);
        boolean result = this.isForwardedHeader(header);
        return result;
    }

    protected boolean isPointerToForwardedObjectCarefully(Pointer p) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointerCarefully(p);
        boolean result = this.isForwardedHeaderCarefully(header);
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord readHeaderBitsFromObject(Object o) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObject(o);
        return ObjectHeaderImpl.getHeaderBitsFromHeader(header);
    }

    private static UnsignedWord readHeaderBitsFromObjectCarefully(Object o) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(o);
        return ObjectHeaderImpl.getHeaderBitsFromHeaderCarefully(header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord getHeaderBitsFromHeader(UnsignedWord header) {
        assert (!ObjectHeaderImpl.isProducedHeapChunkZapped(header)) : "Produced chunk zap value";
        assert (!ObjectHeaderImpl.isConsumedHeapChunkZapped(header)) : "Consumed chunk zap value";
        return header.and(MASK_HEADER_BITS);
    }

    protected static UnsignedWord getHeaderBitsFromHeaderCarefully(UnsignedWord header) {
        VMError.guarantee(!ObjectHeaderImpl.isProducedHeapChunkZapped(header), "Produced chunk zap value");
        VMError.guarantee(!ObjectHeaderImpl.isConsumedHeapChunkZapped(header), "Consumed chunk zap value");
        return header.and(MASK_HEADER_BITS);
    }

    private static void setHeaderBitsOnObject(Object o, UnsignedWord headerBits) {
        UnsignedWord oldHeader = ObjectHeaderImpl.readHeaderFromObject(o);
        UnsignedWord newHeader = ObjectHeaderImpl.clearBits(oldHeader).or(headerBits);
        ObjectHeaderImpl.writeHeaderToObject(o, (WordBase)newHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean headerBitsEqual(UnsignedWord headerBits, UnsignedWord specifiedBits) {
        return headerBits.equal(specifiedBits);
    }

    public String toStringFromObject(Object o) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObject(o);
        return this.toStringFromHeader(header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getHubOffset() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getReferenceSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Fold
    static boolean hasBase() {
        return ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Fold
    static int getCompressionShift() {
        return ReferenceAccess.singleton().getCompressEncoding().getShift();
    }

    public String toStringFromHeader(UnsignedWord header) {
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeader(header);
        if (ObjectHeaderImpl.isNoRememberedSetAlignedHeaderBits(headerBits)) {
            return "NO_REMEMBERED_SET_ALIGNED";
        }
        if (ObjectHeaderImpl.isNoRememberedSetUnalignedHeaderBits(headerBits)) {
            return "NO_REMEMBERED_SET_UNALIGNED";
        }
        if (ObjectHeaderImpl.isBootImageHeaderBits(headerBits)) {
            return "BOOT_IMAGE";
        }
        if (headerBits.equal(UNUSED_100)) {
            return "UNUSED_100";
        }
        if (headerBits.equal(UNUSED_101)) {
            return "UNUSED_101";
        }
        if (ObjectHeaderImpl.isCardRememberedSetAlignedHeaderBits(headerBits)) {
            return "CARD_REMEMBERED_SET_ALIGNED";
        }
        if (ObjectHeaderImpl.isCardRememberedSetUnalignedHeaderBits(headerBits)) {
            return "CARD_REMEMBERED_SET_UNALIGNED";
        }
        if (this.isForwardedHeader(headerBits)) {
            return "FORWARDED";
        }
        return "UNKNOWN_CARD_REMEMBERED_SET_OBJECT_HEADER_BITS";
    }

    public Log logObjectHeader(Object obj, Log log) {
        log.string("  obj: ").hex((WordBase)Word.objectToUntrackedPointer((Object)obj));
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
        DynamicHub hub = this.dynamicHubFromObjectHeader(header);
        log.string("  header: ").hex((WordBase)header).string("  hub: ").hex((WordBase)Word.objectToUntrackedPointer((Object)hub)).string("  bits: ").string(ObjectHeaderImpl.getObjectHeaderImpl().toStringFromHeader(header));
        if (!HeapImpl.getHeapImpl().assertHub(hub)) {
            log.string("  hub fails to verify");
        }
        return log;
    }

    public static int classifyHeader(UnsignedWord header) {
        if (header.equal((UnsignedWord)WordFactory.zero())) {
            return -1000000;
        }
        if (ObjectHeaderImpl.isProducedHeapChunkZapped(header)) {
            return -2000000;
        }
        if (ObjectHeaderImpl.isConsumedHeapChunkZapped(header)) {
            return -3000000;
        }
        UnsignedWord headerBits = ObjectHeaderImpl.getHeaderBitsFromHeaderCarefully(header);
        int headerBitsClassification = headerBits.equal(NO_REMEMBERED_SET_ALIGNED) ? 1 : (headerBits.equal(CARD_REMEMBERED_SET_ALIGNED) ? 2 : (headerBits.equal(NO_REMEMBERED_SET_UNALIGNED) ? 3 : (headerBits.equal(CARD_REMEMBERED_SET_UNALIGNED) ? 4 : (headerBits.equal(BOOT_IMAGE) ? 5 : (headerBits.equal(FORWARDED) ? 6 : -1)))));
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader(header);
        int hubClassification = HeapVerifierImpl.classifyObject(hub);
        return 1000 * hubClassification + headerBitsClassification;
    }
}

