/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class ImageHeapInfo {
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableReferenceObject;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ImageHeapInfo() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initialize(Object firstReadOnlyPrimitiveObject, Object lastReadOnlyPrimitiveObject, Object firstReadOnlyReferenceObject, Object lastReadOnlyReferenceObject, Object firstWritablePrimitiveObject, Object lastWritablePrimitiveObject, Object firstWritableReferenceObject, Object lastWritableReferenceObject) {
        this.firstReadOnlyPrimitiveObject = firstReadOnlyPrimitiveObject;
        this.lastReadOnlyPrimitiveObject = lastReadOnlyPrimitiveObject;
        this.firstReadOnlyReferenceObject = firstReadOnlyReferenceObject;
        this.lastReadOnlyReferenceObject = lastReadOnlyReferenceObject;
        this.firstWritablePrimitiveObject = firstWritablePrimitiveObject;
        this.lastWritablePrimitiveObject = lastWritablePrimitiveObject;
        this.firstWritableReferenceObject = firstWritableReferenceObject;
        this.lastWritableReferenceObject = lastWritableReferenceObject;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyPrimitivePartition(Pointer ptr) {
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyPrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyPrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritablePrimitivePartition(Pointer ptr) {
        return Word.objectToUntrackedPointer((Object)this.firstWritablePrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritablePrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyReferencePartition(Pointer ptr) {
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyReferenceObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableReferencePartition(Pointer ptr) {
        return Word.objectToUntrackedPointer((Object)this.firstWritableReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritableReferenceObject));
    }

    public boolean isObjectInReadOnlyPrimitivePartition(Object obj) {
        return this.isInReadOnlyPrimitivePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public boolean isObjectInWritablePrimitivePartition(Object obj) {
        return this.isInWritablePrimitivePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public boolean isObjectInReadOnlyReferencePartition(Object obj) {
        return this.isInReadOnlyReferencePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public boolean isObjectInWritableReferencePartition(Object obj) {
        return this.isInWritableReferencePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }
}

