/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImplMemoryMXBean;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.ReadOnlyPrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyReferenceMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.WritablePrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritableReferenceMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.gc.CardTableBarrierSet;
import org.graalvm.compiler.nodes.spi.GCProvider;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapImpl
extends Heap {
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration = new OldGeneration("OldGeneration");
    final HeapChunkProvider chunkProvider;
    private final GenScavengeGCProvider gcProvider;
    private final MemoryMXBean memoryMXBean;
    private final ImageHeapInfo imageHeapInfo;
    private final ReadOnlyPrimitiveMemoryWalkerAccess readOnlyPrimitiveWalker;
    private final ReadOnlyReferenceMemoryWalkerAccess readOnlyReferenceWalker;
    private final WritablePrimitiveMemoryWalkerAccess writablePrimitiveWalker;
    private final WritableReferenceMemoryWalkerAccess writableReferenceWalker;
    private List<Class<?>> classList;
    private final ObjectHeaderImpl objectHeaderImpl = new ObjectHeaderImpl();
    private final GCImpl gcImpl;
    private final HeapPolicy heapPolicy;
    private UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead;
    private HeapVerifierImpl heapVerifier;
    private final StackVerifier stackVerifier;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl(Feature.FeatureAccess access) {
        this.gcImpl = new GCImpl(access);
        this.heapPolicy = new HeapPolicy(access);
        this.pinHead = new UninterruptibleUtils.AtomicReference();
        if (HeapImpl.getVerifyHeapBeforeGC() || HeapImpl.getVerifyHeapAfterGC() || HeapImpl.getVerifyStackBeforeGC() || HeapImpl.getVerifyStackAfterGC()) {
            this.heapVerifier = HeapVerifierImpl.factory();
            this.stackVerifier = new StackVerifier();
        } else {
            this.heapVerifier = null;
            this.stackVerifier = null;
        }
        this.chunkProvider = new HeapChunkProvider();
        this.gcProvider = new GenScavengeGCProvider();
        this.memoryMXBean = new HeapImplMemoryMXBean();
        this.imageHeapInfo = new ImageHeapInfo();
        this.readOnlyPrimitiveWalker = new ReadOnlyPrimitiveMemoryWalkerAccess();
        this.readOnlyReferenceWalker = new ReadOnlyReferenceMemoryWalkerAccess();
        this.writablePrimitiveWalker = new WritablePrimitiveMemoryWalkerAccess();
        this.writableReferenceWalker = new WritableReferenceMemoryWalkerAccess();
        this.classList = null;
        SubstrateUtil.DiagnosticThunkRegister.getSingleton().register(() -> {
            this.bootImageHeapBoundariesToLog(Log.log()).newline();
            this.zapValuesToLog(Log.log()).newline();
            this.report(Log.log(), true).newline();
            Log.log().newline();
        });
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Fold
    public static ImageHeapInfo getImageHeapInfo() {
        return HeapImpl.getHeapImpl().imageHeapInfo;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object object) {
        return this.objectHeaderImpl.isBootImage(object);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer pointer) {
        return this.imageHeapInfo.isInReadOnlyPrimitivePartition(pointer) || this.imageHeapInfo.isInReadOnlyReferencePartition(pointer) || this.imageHeapInfo.isInWritablePrimitivePartition(pointer) || this.imageHeapInfo.isInWritableReferencePartition(pointer);
    }

    @Override
    public void suspendAllocation() {
        ThreadLocalAllocation.suspendThreadLocalAllocation();
    }

    @Override
    public void resumeAllocation() {
        ThreadLocalAllocation.resumeThreadLocalAllocation();
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkImageHeapObjects(visitor) && this.walkCollectedHeapObjects(visitor);
    }

    public boolean walkMemory(MemoryWalker.Visitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkNativeImageHeap(visitor) && this.getYoungGeneration().walkHeapChunks(visitor) && this.getOldGeneration().walkHeapChunks(visitor) && HeapChunkProvider.get().walkHeapChunks(visitor);
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public final boolean tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapChunkProvider.get().tearDown();
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeaderImpl;
    }

    public ObjectHeaderImpl getObjectHeaderImpl() {
        return this.objectHeaderImpl;
    }

    @Override
    public GC getGC() {
        return this.getGCImpl();
    }

    public GCImpl getGCImpl() {
        return this.gcImpl;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || this.gcImpl.collectionInProgress.getState();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    final Space getAllocationSpace() {
        return this.getYoungGeneration().getSpace();
    }

    public HeapChunk.Header<?> getEnclosingHeapChunk(Object obj) {
        ObjectHeaderImpl ohi = this.getObjectHeaderImpl();
        if (ohi.isAlignedObject(obj)) {
            return AlignedHeapChunk.getEnclosingAlignedHeapChunk(obj);
        }
        if (ohi.isUnalignedObject(obj)) {
            return UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(obj);
        }
        try (Log failure = Log.log().string("[HeapImpl.getEnclosingHeapChunk:");){
            failure.string("  obj: ").hex((WordBase)Word.objectToUntrackedPointer((Object)obj));
            UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
            failure.string("  header: ").hex((WordBase)header).string("  is neither aligned nor unaligned").newline();
            failure.string("  obj: ").object(obj).string("]").newline();
        }
        throw VMError.shouldNotReachHere();
    }

    public Object promoteObject(Object original) {
        Log trace = Log.noopLog().string("[HeapImpl.promoteObject:").string("  original: ").object(original);
        OldGeneration oldGen = this.getOldGeneration();
        Object result = oldGen.promoteObject(original);
        trace.string("  result: ").object(result).string("]").newline();
        return result;
    }

    boolean hasSurvivedThisCollection(Object obj) {
        ObjectHeaderImpl ohi = this.getObjectHeaderImpl();
        if (ohi.isBootImage(obj)) {
            return true;
        }
        if (ohi.isHeapAllocated(obj)) {
            OldGeneration oldGen;
            HeapChunk.Header<?> chunk = this.getEnclosingHeapChunk(obj);
            Space space = chunk.getSpace();
            return space == (oldGen = this.getOldGeneration()).getToSpace();
        }
        return false;
    }

    public HeapPolicy getHeapPolicy() {
        return HeapImpl.getHeapImpl().heapPolicy;
    }

    public boolean isYoungGeneration(Space space) {
        return this.getYoungGeneration().isYoungSpace(space);
    }

    public YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    public OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    public UninterruptibleUtils.AtomicReference<PinnedObjectImpl> getPinHead() {
        return this.pinHead;
    }

    public boolean isPinned(Object instance) {
        ObjectHeaderImpl ohi = this.getObjectHeaderImpl();
        if (ohi.isBootImage(instance)) {
            return true;
        }
        for (PinnedObjectImpl pinnedObject = this.getPinHead().get(); pinnedObject != null; pinnedObject = pinnedObject.getNext()) {
            if (instance != pinnedObject.getObject()) continue;
            return true;
        }
        return false;
    }

    UnsignedWord getUsedChunkBytes() {
        UnsignedWord youngBytes = this.getYoungUsedChunkBytes();
        UnsignedWord oldBytes = this.getOldUsedChunkBytes();
        return youngBytes.add(oldBytes);
    }

    UnsignedWord getYoungUsedChunkBytes() {
        Space.Accounting young = this.getYoungGeneration().getSpace().getAccounting();
        return young.getAlignedChunkBytes().add(young.getUnalignedChunkBytes());
    }

    UnsignedWord getOldUsedChunkBytes() {
        Log trace = Log.noopLog().string("[HeapImpl.getOldUsedChunkBytes:");
        Space.Accounting from = this.getOldGeneration().getFromSpace().getAccounting();
        UnsignedWord fromBytes = from.getAlignedChunkBytes().add(from.getUnalignedChunkBytes());
        Space.Accounting to = this.getOldGeneration().getToSpace().getAccounting();
        UnsignedWord toBytes = to.getAlignedChunkBytes().add(to.getUnalignedChunkBytes());
        UnsignedWord result = fromBytes.add(toBytes);
        if (trace.isEnabled()) {
            trace.string("  fromAligned: ").unsigned((WordBase)from.getAlignedChunkBytes()).string("  fromUnaligned: ").signed((WordBase)from.getUnalignedChunkBytes()).string("  toAligned: ").unsigned((WordBase)to.getAlignedChunkBytes()).string("  toUnaligned: ").signed((WordBase)to.getUnalignedChunkBytes()).string("  returns: ").unsigned((WordBase)result).string(" ]").newline();
        }
        return result;
    }

    public UnsignedWord getUsedObjectBytes() {
        Space youngSpace = this.getYoungGeneration().getSpace();
        UnsignedWord youngBytes = youngSpace.getObjectBytes();
        Space fromSpace = this.getOldGeneration().getFromSpace();
        UnsignedWord fromBytes = fromSpace.getObjectBytes();
        return youngBytes.add(fromBytes);
    }

    protected void report(Log log) {
        this.report(log, HeapPolicyOptions.TraceHeapChunks.getValue());
    }

    public Log report(Log log, boolean traceHeapChunks) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        log.newline().string("[Heap:").indent(true);
        heap.getYoungGeneration().report(log, traceHeapChunks).newline();
        heap.getOldGeneration().report(log, traceHeapChunks).newline();
        HeapChunkProvider.get().report(log, traceHeapChunks);
        log.redent(false).string("]");
        return log;
    }

    Log bootImageHeapBoundariesToLog(Log log) {
        log.string("[Native image heap boundaries: ").indent(true);
        log.string("ReadOnly Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.firstReadOnlyPrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.lastReadOnlyPrimitiveObject)).newline();
        log.string("ReadOnly References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.firstReadOnlyReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.lastReadOnlyReferenceObject)).newline();
        log.string("Writable Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.firstWritablePrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.lastWritablePrimitiveObject)).newline();
        log.string("Writable References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.firstWritableReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)this.imageHeapInfo.lastWritableReferenceObject));
        log.redent(false).string("]");
        return log;
    }

    Log zapValuesToLog(Log log) {
        if (HeapPolicy.getZapProducedHeapChunks() || HeapPolicy.getZapConsumedHeapChunks()) {
            log.string("[Heap Chunk zap values: ").indent(true);
            if (HeapPolicy.getZapProducedHeapChunks()) {
                log.string("  producedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getProducedHeapChunkZapInt()).string("  signed: ").spaces(9).signed(HeapPolicy.getProducedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getProducedHeapChunkZapInt()).newline();
                log.string("  producedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getProducedHeapChunkZapWord());
                if (HeapPolicy.getZapConsumedHeapChunks()) {
                    log.newline();
                }
            }
            if (HeapPolicy.getZapConsumedHeapChunks()) {
                log.string("  consumedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getConsumedHeapChunkZapInt()).string("  signed: ").spaces(10).signed(HeapPolicy.getConsumedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getConsumedHeapChunkZapInt()).newline();
                log.string("  consumedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getConsumedHeapChunkZapWord());
            }
            log.redent(false).string("]");
        }
        return log;
    }

    @Override
    public MemoryMXBean getMemoryMXBean() {
        return this.memoryMXBean;
    }

    @Override
    public List<Class<?>> getClassList() {
        if (this.classList == null) {
            ArrayList<Class> list = new ArrayList<Class>(1024);
            Object firstObject = this.imageHeapInfo.firstReadOnlyReferenceObject;
            Object lastObject = this.imageHeapInfo.lastReadOnlyReferenceObject;
            Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
            Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
            Word currentPointer = firstPointer;
            while (currentPointer.belowOrEqual((UnsignedWord)lastPointer)) {
                Object currentObject = KnownIntrinsics.convertUnknownValue(currentPointer.toObject(), Object.class);
                if (currentObject instanceof Class) {
                    Class asClass = (Class)currentObject;
                    list.add(asClass);
                }
                currentPointer = LayoutEncoding.getObjectEnd(currentObject);
            }
            this.classList = Collections.unmodifiableList(list);
        }
        return this.classList;
    }

    HeapVerifier getHeapVerifier() {
        return this.getHeapVerifierImpl();
    }

    public HeapVerifierImpl getHeapVerifierImpl() {
        return this.heapVerifier;
    }

    void setHeapVerifierImpl(HeapVerifierImpl value) {
        this.heapVerifier = value;
    }

    @Fold
    static boolean getVerifyHeapBeforeGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyHeapAfterGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapAfterCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackBeforeGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackAfterGC() {
        return SubstrateOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackAfterCollection.getValue() != false;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    void verifyBeforeGC(String cause, UnsignedWord epoch) {
        Log trace = Log.noopLog().string("[HeapImpl.verifyBeforeGC:");
        trace.string("  getVerifyHeapBeforeGC(): ").bool(HeapImpl.getVerifyHeapBeforeGC()).string("  heapVerifier: ").object(this.heapVerifier);
        trace.string("  getVerifyStackBeforeGC(): ").bool(HeapImpl.getVerifyStackBeforeGC()).string("  stackVerifier: ").object(this.stackVerifier);
        if (HeapImpl.getVerifyHeapBeforeGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("before collection", HeapVerifier.Occasion.BEFORE_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  heap fails to verify before epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackBeforeGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), "before collection")) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  stack fails to verify epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        trace.string("]").newline();
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    void verifyAfterGC(String cause, UnsignedWord epoch) {
        if (HeapImpl.getVerifyHeapAfterGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("after collection", HeapVerifier.Occasion.AFTER_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  heap fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackAfterGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), "after collection")) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  stack fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
    }

    public boolean assertHub(DynamicHub hub) {
        return this.imageHeapInfo.isObjectInReadOnlyReferencePartition(hub);
    }

    public boolean assertHubOfObject(Object obj) {
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(obj);
        return this.assertHub(hub);
    }

    public boolean isValidSpace(Space space) {
        return this.getYoungGeneration().isValidSpace(space) || this.getOldGeneration().isValidSpace(space);
    }

    public UnsignedWord freeMemory() {
        return this.maxMemory().subtract(HeapPolicy.getBytesAllocatedSinceLastCollection()).subtract(this.getOldUsedChunkBytes());
    }

    public UnsignedWord totalMemory() {
        return this.maxMemory();
    }

    public UnsignedWord maxMemory() {
        PhysicalMemory.size();
        return HeapPolicy.getMaximumHeapSize();
    }

    @Override
    public GCProvider getGCProvider() {
        return this.gcProvider;
    }

    @Override
    public void prepareForSafepoint() {
    }

    @Override
    public void endSafepoint() {
    }

    @Override
    @Uninterruptible(reason="Called during startup.")
    public void attachThread(IsolateThread isolateThread) {
    }

    @Override
    public void detachThread(IsolateThread isolateThread) {
        ThreadLocalAllocation.disableThreadLocalAllocation(isolateThread);
    }

    @Override
    @Fold
    public int getImageHeapOffsetInAddressSpace() {
        return 0;
    }

    @Override
    public boolean walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        if (visitor != null) {
            return HeapImpl.walkPartition(this.imageHeapInfo.firstReadOnlyPrimitiveObject, this.imageHeapInfo.lastReadOnlyPrimitiveObject, visitor) && HeapImpl.walkPartition(this.imageHeapInfo.firstReadOnlyReferenceObject, this.imageHeapInfo.lastReadOnlyReferenceObject, visitor) && HeapImpl.walkPartition(this.imageHeapInfo.firstWritablePrimitiveObject, this.imageHeapInfo.lastWritablePrimitiveObject, visitor) && HeapImpl.walkPartition(this.imageHeapInfo.firstWritableReferenceObject, this.imageHeapInfo.lastWritableReferenceObject, visitor);
        }
        return true;
    }

    @Override
    public boolean walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        return this.getYoungGeneration().walkObjects(visitor) && this.getOldGeneration().walkObjects(visitor);
    }

    private boolean walkNativeImageHeap(MemoryWalker.Visitor visitor) {
        return visitor.visitNativeImageHeapRegion(this.readOnlyPrimitiveWalker) && visitor.visitNativeImageHeapRegion(this.readOnlyReferenceWalker) && visitor.visitNativeImageHeapRegion(this.writablePrimitiveWalker) && visitor.visitNativeImageHeapRegion(this.writableReferenceWalker);
    }

    private static boolean walkPartition(Object firstObject, Object lastObject, ObjectVisitor visitor) {
        if (firstObject == null || lastObject == null) {
            assert (firstObject == null && lastObject == null);
            return true;
        }
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        while (current.belowOrEqual((UnsignedWord)lastPointer)) {
            Object currentObject = KnownIntrinsics.convertUnknownValue(current.toObject(), Object.class);
            if (!visitor.visitObject(currentObject)) {
                return false;
            }
            current = LayoutEncoding.getObjectEnd(currentObject);
        }
        return true;
    }

    private static class GenScavengeGCProvider
    implements GCProvider {
        private final BarrierSet barrierSet = new CardTableBarrierSet();

        GenScavengeGCProvider() {
        }

        public BarrierSet getBarrierSet() {
            return this.barrierSet;
        }
    }
}

