/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AOTInline": {
                return OptionDescriptor.create((String)"AOTInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform method inlining in the AOT compiled native image", SubstrateOptions.class, (String)"AOTInline", SubstrateOptions.AOTInline);
            }
            case "AOTTrivialInline": {
                return OptionDescriptor.create((String)"AOTTrivialInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform trivial method inlining in the AOT compiled native image", SubstrateOptions.class, (String)"AOTTrivialInline", SubstrateOptions.AOTTrivialInline);
            }
            case "APIFunctionPrefix": {
                return OptionDescriptor.create((String)"APIFunctionPrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of API functions.", SubstrateOptions.class, (String)"APIFunctionPrefix", SubstrateOptions.APIFunctionPrefix);
            }
            case "AllocateInstancePrefetchLines": {
                return OptionDescriptor.create((String)"AllocateInstancePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the object address using prefetch instructions generated in JIT compiled code.", SubstrateOptions.class, (String)"AllocateInstancePrefetchLines", SubstrateOptions.AllocateInstancePrefetchLines);
            }
            case "AllocatePrefetchDistance": {
                return OptionDescriptor.create((String)"AllocatePrefetchDistance", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.", SubstrateOptions.class, (String)"AllocatePrefetchDistance", SubstrateOptions.AllocatePrefetchDistance);
            }
            case "AllocatePrefetchInstr": {
                return OptionDescriptor.create((String)"AllocatePrefetchInstr", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.", SubstrateOptions.class, (String)"AllocatePrefetchInstr", SubstrateOptions.AllocatePrefetchInstr);
            }
            case "AllocatePrefetchLines": {
                return OptionDescriptor.create((String)"AllocatePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the array allocation using prefetch instructions generated in JIT compiled code.", SubstrateOptions.class, (String)"AllocatePrefetchLines", SubstrateOptions.AllocatePrefetchLines);
            }
            case "AllocatePrefetchStepSize": {
                return OptionDescriptor.create((String)"AllocatePrefetchStepSize", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the step size (in bytes) for sequential prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchStepSize", SubstrateOptions.AllocatePrefetchStepSize);
            }
            case "AllocatePrefetchStyle": {
                return OptionDescriptor.create((String)"AllocatePrefetchStyle", (OptionType)OptionType.Debug, Integer.class, (String)"Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.", SubstrateOptions.class, (String)"AllocatePrefetchStyle", SubstrateOptions.AllocatePrefetchStyle);
            }
            case "CCompilerOption": {
                return OptionDescriptor.create((String)"CCompilerOption", (OptionType)OptionType.User, String[].class, (String)"Provide custom C compiler option used for query code compilation.", SubstrateOptions.class, (String)"CCompilerOption", SubstrateOptions.CCompilerOption);
            }
            case "CCompilerPath": {
                return OptionDescriptor.create((String)"CCompilerPath", (OptionType)OptionType.User, String.class, (String)"Provide custom path to C compiler used for query code compilation and linking.", SubstrateOptions.class, (String)"CCompilerPath", SubstrateOptions.CCompilerPath);
            }
            case "CLibraryPath": {
                return OptionDescriptor.create((String)"CLibraryPath", (OptionType)OptionType.Debug, String[].class, (String)"Search path for C libraries passed to the linker (list of comma-separated directories)", SubstrateOptions.class, (String)"CLibraryPath", SubstrateOptions.CLibraryPath);
            }
            case "Class": {
                return OptionDescriptor.create((String)"Class", (OptionType)OptionType.User, String.class, (String)"Class containing the default entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Class", SubstrateOptions.Class);
            }
            case "CompilerBackend": {
                return OptionDescriptor.create((String)"CompilerBackend", (OptionType)OptionType.User, String.class, (String)"Backend used by the compiler", SubstrateOptions.class, (String)"CompilerBackend", SubstrateOptions.CompilerBackend);
            }
            case "DeleteLocalSymbols": {
                return OptionDescriptor.create((String)"DeleteLocalSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to remove all local symbols from image.", SubstrateOptions.class, (String)"DeleteLocalSymbols", SubstrateOptions.DeleteLocalSymbols);
            }
            case "EmitStringEncodingSubstitutions": {
                return OptionDescriptor.create((String)"EmitStringEncodingSubstitutions", (OptionType)OptionType.Debug, Boolean.class, (String)"Emit substitutions for UTF16 and latin1 compression", SubstrateOptions.class, (String)"EmitStringEncodingSubstitutions", SubstrateOptions.EmitStringEncodingSubstitutions);
            }
            case "EnableAllSecurityServices": {
                return OptionDescriptor.create((String)"EnableAllSecurityServices", (OptionType)OptionType.Debug, Boolean.class, (String)"Add all security service classes to the generated image.", SubstrateOptions.class, (String)"EnableAllSecurityServices", SubstrateOptions.EnableAllSecurityServices);
            }
            case "EnableURLProtocols": {
                return OptionDescriptor.create((String)"EnableURLProtocols", (OptionType)OptionType.Debug, String[].class, (String)"List of comma separated URL protocols to enable.", SubstrateOptions.class, (String)"EnableURLProtocols", SubstrateOptions.EnableURLProtocols);
            }
            case "EntryPointNamePrefix": {
                return OptionDescriptor.create((String)"EntryPointNamePrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of entry point methods.", SubstrateOptions.class, (String)"EntryPointNamePrefix", SubstrateOptions.EntryPointNamePrefix);
            }
            case "FallbackThreshold": {
                return OptionDescriptor.create((String)"FallbackThreshold", (OptionType)OptionType.Debug, Integer.class, (String)"Define when fallback-image generation should be used.", SubstrateOptions.class, (String)"FallbackThreshold", SubstrateOptions.FallbackThreshold);
            }
            case "FoldSecurityManagerGetter": {
                return OptionDescriptor.create((String)"FoldSecurityManagerGetter", (OptionType)OptionType.Expert, Boolean.class, (String)"Fold SecurityManager getter.", SubstrateOptions.class, (String)"FoldSecurityManagerGetter", SubstrateOptions.FoldSecurityManagerGetter);
            }
            case "IncludeNodeSourcePositions": {
                return OptionDescriptor.create((String)"IncludeNodeSourcePositions", (OptionType)OptionType.Debug, Boolean.class, (String)"Track NodeSourcePositions during runtime-compilation", SubstrateOptions.class, (String)"IncludeNodeSourcePositions", SubstrateOptions.IncludeNodeSourcePositions);
            }
            case "JNI": {
                return OptionDescriptor.create((String)"JNI", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Native Interface (JNI) support.", SubstrateOptions.class, (String)"JNI", SubstrateOptions.JNI);
            }
            case "JNIExportSymbols": {
                return OptionDescriptor.create((String)"JNIExportSymbols", (OptionType)OptionType.User, Boolean.class, (String)"Export Invocation API symbols.", SubstrateOptions.class, (String)"JNIExportSymbols", SubstrateOptions.JNIExportSymbols);
            }
            case "JNIVerboseLookupErrors": {
                return OptionDescriptor.create((String)"JNIVerboseLookupErrors", (OptionType)OptionType.User, Boolean.class, (String)"Report information about known JNI elements when lookup fails", SubstrateOptions.class, (String)"JNIVerboseLookupErrors", SubstrateOptions.JNIVerboseLookupErrors);
            }
            case "LinkerRPath": {
                return OptionDescriptor.create((String)"LinkerRPath", (OptionType)OptionType.Debug, String[].class, (String)"Path passed to the linker as the -rpath (list of comma-separated directories)", SubstrateOptions.class, (String)"LinkerRPath", SubstrateOptions.LinkerRPath);
            }
            case "MaxHeapSize": {
                return OptionDescriptor.create((String)"MaxHeapSize", (OptionType)OptionType.User, Long.class, (String)"The maximum heap size at run-time, in bytes.", SubstrateOptions.class, (String)"MaxHeapSize", SubstrateOptions.MaxHeapSize);
            }
            case "MaxInvokesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxInvokesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of invokes in a method so that it is considered trivial (for testing only).", SubstrateOptions.class, (String)"MaxInvokesInTrivialMethod", SubstrateOptions.MaxInvokesInTrivialMethod);
            }
            case "MaxNewSize": {
                return OptionDescriptor.create((String)"MaxNewSize", (OptionType)OptionType.User, Long.class, (String)"The maximum size of the young generation at run-time, in bytes", SubstrateOptions.class, (String)"MaxNewSize", SubstrateOptions.MaxNewSize);
            }
            case "MaxNodesInTrivialLeafMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialLeafMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.", SubstrateOptions.class, (String)"MaxNodesInTrivialLeafMethod", SubstrateOptions.MaxNodesInTrivialLeafMethod);
            }
            case "MaxNodesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial.", SubstrateOptions.class, (String)"MaxNodesInTrivialMethod", SubstrateOptions.MaxNodesInTrivialMethod);
            }
            case "MaxUnrolledObjectZeroingStores": {
                return OptionDescriptor.create((String)"MaxUnrolledObjectZeroingStores", (OptionType)OptionType.Debug, Integer.class, (String)"Define the maximum number of stores for which the loop that zeroes out objects is unrolled.", SubstrateOptions.class, (String)"MaxUnrolledObjectZeroingStores", SubstrateOptions.MaxUnrolledObjectZeroingStores);
            }
            case "Method": {
                return OptionDescriptor.create((String)"Method", (OptionType)OptionType.Debug, String.class, (String)"Name of the main entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Method", SubstrateOptions.Method);
            }
            case "MinHeapSize": {
                return OptionDescriptor.create((String)"MinHeapSize", (OptionType)OptionType.User, Long.class, (String)"The minimum heap size at run-time, in bytes.", SubstrateOptions.class, (String)"MinHeapSize", SubstrateOptions.MinHeapSize);
            }
            case "MultiThreaded": {
                return OptionDescriptor.create((String)"MultiThreaded", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable support for threads and and thread-local variables (disable for single-threaded implementation)", SubstrateOptions.class, (String)"MultiThreaded", SubstrateOptions.MultiThreaded);
            }
            case "Name": {
                return OptionDescriptor.create((String)"Name", (OptionType)OptionType.User, String.class, (String)"Name of the output file to be generated", SubstrateOptions.class, (String)"Name", SubstrateOptions.Name);
            }
            case "NeverInline": {
                return OptionDescriptor.create((String)"NeverInline", (OptionType)OptionType.Debug, String[].class, (String)"Pattern for disabling inlining of methods during image generation.", (String[])new String[]{"The syntax for a pattern is:", "", "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .", "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .", "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .", "  Class = { package \".\" } class .", "", "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.", "", "Examples of method filters:", "---------", "  visit(Argument;BlockScope)", "", "  Matches all methods named \"visit\", with the first parameter of", "  type \"Argument\", and the second parameter of type \"BlockScope\".", "  The packages of the parameter types are irrelevant.", "---------", "  arraycopy(Object;;;;)", "", "  Matches all methods named \"arraycopy\", with the first parameter", "  of type \"Object\", and four more parameters of any type. The", "  packages of the parameter types are irrelevant.", "---------", "  org.graalvm.compiler.core.graph.PostOrderNodeIterator.*", "", "  Matches all methods in the class \"org.graalvm.compiler.core.graph.PostOrderNodeIterator\".", "---------", "  *", "", "  Matches all methods in all classes", "---------", "  org.graalvm.compiler.core.graph.*.visit", "", "  Matches all methods named \"visit\" in classes in the package", "  \"org.graalvm.compiler.core.graph\".", "---------", "  arraycopy,toString", "", "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator."}, SubstrateOptions.class, (String)"NeverInline", SubstrateOptions.NeverInline);
            }
            case "Optimize": {
                return OptionDescriptor.create((String)"Optimize", (OptionType)OptionType.User, Integer.class, (String)"Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations.", SubstrateOptions.class, (String)"Optimize", SubstrateOptions.Optimize);
            }
            case "ParseRuntimeOptions": {
                return OptionDescriptor.create((String)"ParseRuntimeOptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Parse and consume standard options and system properties from the command line arguments when the VM is created.", SubstrateOptions.class, (String)"ParseRuntimeOptions", SubstrateOptions.ParseRuntimeOptions);
            }
            case "Path": {
                return OptionDescriptor.create((String)"Path", (OptionType)OptionType.User, String.class, (String)"Directory of the image file to be generated", SubstrateOptions.class, (String)"Path", SubstrateOptions.Path);
            }
            case "PreserveFramePointer": {
                return OptionDescriptor.create((String)"PreserveFramePointer", (OptionType)OptionType.Debug, Boolean.class, (String)"Saves stack base pointer on the stack on method entry.", SubstrateOptions.class, (String)"PreserveFramePointer", SubstrateOptions.PreserveFramePointer);
            }
            case "PrintFlags": {
                return OptionDescriptor.create((String)"PrintFlags", (OptionType)OptionType.Debug, String.class, (String)"Show available options based on comma-separated option-types (allowed categories: User, Expert, Debug).", SubstrateOptions.class, (String)"PrintFlags", SubstrateOptions.PrintFlags);
            }
            case "PrintGC": {
                return OptionDescriptor.create((String)"PrintGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Print summary GC information after each collection", SubstrateOptions.class, (String)"PrintGC", SubstrateOptions.PrintGC);
            }
            case "RemoveUnusedSymbols": {
                return OptionDescriptor.create((String)"RemoveUnusedSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to prevent unreferenced symbols in image.", SubstrateOptions.class, (String)"RemoveUnusedSymbols", SubstrateOptions.RemoveUnusedSymbols);
            }
            case "ReportAnalysisForbiddenType": {
                return OptionDescriptor.create((String)"ReportAnalysisForbiddenType", (OptionType)OptionType.Debug, String[].class, (String)"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, InTypeCheck).", SubstrateOptions.class, (String)"ReportAnalysisForbiddenType", SubstrateOptions.ReportAnalysisForbiddenType);
            }
            case "RuntimeAssertions": {
                return OptionDescriptor.create((String)"RuntimeAssertions", (OptionType)OptionType.User, Boolean.class, (String)"Enable or disable Java assert statements at run time", SubstrateOptions.class, (String)"RuntimeAssertions", SubstrateOptions.RuntimeAssertions);
            }
            case "RuntimeAssertionsFilter": {
                return OptionDescriptor.create((String)"RuntimeAssertionsFilter", (OptionType)OptionType.Debug, String[].class, (String)"Only use Java assert statements for classes that are matching the comma-separated list of package prefixes.", SubstrateOptions.class, (String)"RuntimeAssertionsFilter", SubstrateOptions.RuntimeAssertionsFilter);
            }
            case "SharedLibrary": {
                return OptionDescriptor.create((String)"SharedLibrary", (OptionType)OptionType.Debug, Boolean.class, (String)"Build shared library", SubstrateOptions.class, (String)"SharedLibrary", SubstrateOptions.SharedLibrary);
            }
            case "SpawnIsolates": {
                return OptionDescriptor.create((String)"SpawnIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support multiple isolates. ", SubstrateOptions.class, (String)"SpawnIsolates", SubstrateOptions.SpawnIsolates);
            }
            case "StackSize": {
                return OptionDescriptor.create((String)"StackSize", (OptionType)OptionType.User, Long.class, (String)"The size of each thread stack at run-time, in bytes.", SubstrateOptions.class, (String)"StackSize", SubstrateOptions.StackSize);
            }
            case "StackTrace": {
                return OptionDescriptor.create((String)"StackTrace", (OptionType)OptionType.Debug, Boolean.class, (String)"Provide method names for stack traces.", SubstrateOptions.class, (String)"StackTrace", SubstrateOptions.StackTrace);
            }
            case "StaticExecutable": {
                return OptionDescriptor.create((String)"StaticExecutable", (OptionType)OptionType.Debug, Boolean.class, (String)"Build statically linked executable (requires static libc and zlib)", SubstrateOptions.class, (String)"StaticExecutable", SubstrateOptions.StaticExecutable);
            }
            case "TearDownFailureNanos": {
                return OptionDescriptor.create((String)"TearDownFailureNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.", SubstrateOptions.class, (String)"TearDownFailureNanos", SubstrateOptions.TearDownFailureNanos);
            }
            case "TearDownWarningNanos": {
                return OptionDescriptor.create((String)"TearDownWarningNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.", SubstrateOptions.class, (String)"TearDownWarningNanos", SubstrateOptions.TearDownWarningNanos);
            }
            case "TraceClassInitialization": {
                return OptionDescriptor.create((String)"TraceClassInitialization", (OptionType)OptionType.Debug, Boolean.class, (String)"Instrument code to trace and report class initialization.", SubstrateOptions.class, (String)"TraceClassInitialization", SubstrateOptions.TraceClassInitialization);
            }
            case "TraceVMOperations": {
                return OptionDescriptor.create((String)"TraceVMOperations", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace VMOperation execution.", SubstrateOptions.class, (String)"TraceVMOperations", SubstrateOptions.TraceVMOperations);
            }
            case "UseCalleeSavedRegisters": {
                return OptionDescriptor.create((String)"UseCalleeSavedRegisters", (OptionType)OptionType.Debug, Boolean.class, (String)"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)", SubstrateOptions.class, (String)"UseCalleeSavedRegisters", SubstrateOptions.UseCalleeSavedRegisters);
            }
            case "UseCardRememberedSetHeap": {
                return OptionDescriptor.create((String)"UseCardRememberedSetHeap", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a card remembered set heap for GC", SubstrateOptions.class, (String)"UseCardRememberedSetHeap", SubstrateOptions.UseCardRememberedSetHeap);
            }
            case "UseDedicatedVMOperationThread": {
                return OptionDescriptor.create((String)"UseDedicatedVMOperationThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM operations should be executed in a dedicated thread.", SubstrateOptions.class, (String)"UseDedicatedVMOperationThread", SubstrateOptions.UseDedicatedVMOperationThread);
            }
            case "UseMuslC": {
                return OptionDescriptor.create((String)"UseMuslC", (OptionType)OptionType.Expert, String.class, (String)"Builds a native image using libmusl as the libc implementation.", (String[])new String[]{"Usage: -H:UseMuslC=<path to musl bundle>", "---------", "The musl bundle path should contain the following structure:", "- include", "- lib", "Under those two folders, the following libraries must be available:", "- musl", "- zlib", "- libstdc++ (if using libsunec)", "", "One of the ways of constructing the bundle:", "1. Create a folder for the bundle", "2. Download musl sources", "3. Configure musl to use the path to the bundle as the install destination", "4. Repeat steps 2 and 3 for zlib", "5. For libstdc++.a, the easiest way to download it from the Alpine distribution.", "The harder way is to compile it yourself. libstdc++ comes as part of gcc. To compile it yourself and use it means to", "compile GCC using musl and rip it from the result."}, SubstrateOptions.class, (String)"UseMuslC", SubstrateOptions.UseMuslC);
            }
            case "UseOnlyWritableBootImageHeap": {
                return OptionDescriptor.create((String)"UseOnlyWritableBootImageHeap", (OptionType)OptionType.Debug, Boolean.class, (String)"Use only a writable native image heap.", SubstrateOptions.class, (String)"UseOnlyWritableBootImageHeap", SubstrateOptions.UseOnlyWritableBootImageHeap);
            }
            case "VerboseGC": {
                return OptionDescriptor.create((String)"VerboseGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Print more information about the heap before and after each collection", SubstrateOptions.class, (String)"VerboseGC", SubstrateOptions.VerboseGC);
            }
            case "VerifyHeap": {
                return OptionDescriptor.create((String)"VerifyHeap", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap before and after each collection.", SubstrateOptions.class, (String)"VerifyHeap", SubstrateOptions.VerifyHeap);
            }
            case "VerifyNamingConventions": {
                return OptionDescriptor.create((String)"VerifyNamingConventions", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify naming conventions during image construction.", SubstrateOptions.class, (String)"VerifyNamingConventions", SubstrateOptions.VerifyNamingConventions);
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 64;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTInline");
                    }
                    case 1: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTTrivialInline");
                    }
                    case 2: {
                        return SubstrateOptions_OptionDescriptors.this.get("APIFunctionPrefix");
                    }
                    case 3: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocateInstancePrefetchLines");
                    }
                    case 4: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchDistance");
                    }
                    case 5: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchInstr");
                    }
                    case 6: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchLines");
                    }
                    case 7: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStepSize");
                    }
                    case 8: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStyle");
                    }
                    case 9: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerOption");
                    }
                    case 10: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerPath");
                    }
                    case 11: {
                        return SubstrateOptions_OptionDescriptors.this.get("CLibraryPath");
                    }
                    case 12: {
                        return SubstrateOptions_OptionDescriptors.this.get("Class");
                    }
                    case 13: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilerBackend");
                    }
                    case 14: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeleteLocalSymbols");
                    }
                    case 15: {
                        return SubstrateOptions_OptionDescriptors.this.get("EmitStringEncodingSubstitutions");
                    }
                    case 16: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableAllSecurityServices");
                    }
                    case 17: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableURLProtocols");
                    }
                    case 18: {
                        return SubstrateOptions_OptionDescriptors.this.get("EntryPointNamePrefix");
                    }
                    case 19: {
                        return SubstrateOptions_OptionDescriptors.this.get("FallbackThreshold");
                    }
                    case 20: {
                        return SubstrateOptions_OptionDescriptors.this.get("FoldSecurityManagerGetter");
                    }
                    case 21: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeNodeSourcePositions");
                    }
                    case 22: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNI");
                    }
                    case 23: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIExportSymbols");
                    }
                    case 24: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIVerboseLookupErrors");
                    }
                    case 25: {
                        return SubstrateOptions_OptionDescriptors.this.get("LinkerRPath");
                    }
                    case 26: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxHeapSize");
                    }
                    case 27: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxInvokesInTrivialMethod");
                    }
                    case 28: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNewSize");
                    }
                    case 29: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialLeafMethod");
                    }
                    case 30: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialMethod");
                    }
                    case 31: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxUnrolledObjectZeroingStores");
                    }
                    case 32: {
                        return SubstrateOptions_OptionDescriptors.this.get("Method");
                    }
                    case 33: {
                        return SubstrateOptions_OptionDescriptors.this.get("MinHeapSize");
                    }
                    case 34: {
                        return SubstrateOptions_OptionDescriptors.this.get("MultiThreaded");
                    }
                    case 35: {
                        return SubstrateOptions_OptionDescriptors.this.get("Name");
                    }
                    case 36: {
                        return SubstrateOptions_OptionDescriptors.this.get("NeverInline");
                    }
                    case 37: {
                        return SubstrateOptions_OptionDescriptors.this.get("Optimize");
                    }
                    case 38: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseRuntimeOptions");
                    }
                    case 39: {
                        return SubstrateOptions_OptionDescriptors.this.get("Path");
                    }
                    case 40: {
                        return SubstrateOptions_OptionDescriptors.this.get("PreserveFramePointer");
                    }
                    case 41: {
                        return SubstrateOptions_OptionDescriptors.this.get("PrintFlags");
                    }
                    case 42: {
                        return SubstrateOptions_OptionDescriptors.this.get("PrintGC");
                    }
                    case 43: {
                        return SubstrateOptions_OptionDescriptors.this.get("RemoveUnusedSymbols");
                    }
                    case 44: {
                        return SubstrateOptions_OptionDescriptors.this.get("ReportAnalysisForbiddenType");
                    }
                    case 45: {
                        return SubstrateOptions_OptionDescriptors.this.get("RuntimeAssertions");
                    }
                    case 46: {
                        return SubstrateOptions_OptionDescriptors.this.get("RuntimeAssertionsFilter");
                    }
                    case 47: {
                        return SubstrateOptions_OptionDescriptors.this.get("SharedLibrary");
                    }
                    case 48: {
                        return SubstrateOptions_OptionDescriptors.this.get("SpawnIsolates");
                    }
                    case 49: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackSize");
                    }
                    case 50: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackTrace");
                    }
                    case 51: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutable");
                    }
                    case 52: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownFailureNanos");
                    }
                    case 53: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownWarningNanos");
                    }
                    case 54: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceClassInitialization");
                    }
                    case 55: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceVMOperations");
                    }
                    case 56: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCalleeSavedRegisters");
                    }
                    case 57: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCardRememberedSetHeap");
                    }
                    case 58: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDedicatedVMOperationThread");
                    }
                    case 59: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseMuslC");
                    }
                    case 60: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseOnlyWritableBootImageHeap");
                    }
                    case 61: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerboseGC");
                    }
                    case 62: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyHeap");
                    }
                    case 63: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyNamingConventions");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

