/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.heap.DiscoverableReference;
import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import java.lang.ref.Reference;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;

public class SubstrateTruffleGraphBuilderPlugins {
    static void registerCompilationFinalReferencePlugins(InvocationPlugins plugins, final boolean canDelayIntrinsification, final SubstrateKnownTruffleTypes types) {
        InvocationPlugins.Registration r0 = new InvocationPlugins.Registration(plugins, Reference.class);
        r0.register1("get", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant reference;
                if (!canDelayIntrinsification && receiver.isConstant() && (reference = (JavaConstant)receiver.get().asConstant()).isNonNull()) {
                    JavaConstant referent = this.readReferent(reference, b.getConstantReflection());
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)referent, (MetaAccessProvider)b.getMetaAccess()));
                    return true;
                }
                return false;
            }

            private JavaConstant readReferent(JavaConstant reference, ConstantReflectionProvider constantReflection) {
                JavaConstant feebleReference = constantReflection.readFieldValue(types.referenceFieldFeeble, reference);
                if (feebleReference.isNonNull()) {
                    return constantReflection.readFieldValue(types.discoverableReferenceFieldRawReferent, feebleReference);
                }
                return constantReflection.readFieldValue(types.referenceFieldBootImageStrongValue, reference);
            }
        });
        InvocationPlugins.Registration r1 = new InvocationPlugins.Registration(plugins, DiscoverableReference.class);
        r1.register1("getReferentObject", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constant;
                if (!canDelayIntrinsification && receiver.isConstant() && (constant = (JavaConstant)receiver.get().asConstant()).isNonNull()) {
                    JavaConstant referent = b.getConstantReflection().readFieldValue(types.discoverableReferenceFieldRawReferent, constant);
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)referent, (MetaAccessProvider)b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
    }
}

