/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.jni.JNIGlobalHandles;
import com.oracle.svm.jni.JNIImageHeapHandles;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIObjectRefType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.SignedWord;

public final class JNIObjectHandles {
    static final int NATIVE_CALL_MIN_LOCAL_HANDLE_CAPACITY = 16;
    private static final FastThreadLocalObject<ThreadLocalHandles> handles = FastThreadLocalFactory.createObject(ThreadLocalHandles.class);

    @Fold
    static boolean haveAssertions() {
        return SubstrateOptions.getRuntimeAssertionsForClass(JNIObjectHandles.class.getName());
    }

    public static <T extends SignedWord> T nullHandle() {
        return (T)ThreadLocalHandles.nullHandle();
    }

    @Fold
    static boolean useImageHeapHandles() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    private static ThreadLocalHandles<ObjectHandle> getLocals() {
        if (handles.get() == null) {
            handles.set(new ThreadLocalHandles(16));
        }
        return handles.get();
    }

    private static boolean isInLocalRange(JNIObjectHandle handle) {
        return ThreadLocalHandles.isInRange((ObjectHandle)handle);
    }

    private static ObjectHandle decodeLocal(JNIObjectHandle handle) {
        return (ObjectHandle)handle;
    }

    private static JNIObjectHandle encodeLocal(ObjectHandle handle) {
        return (JNIObjectHandle)handle;
    }

    public static <T> T getObject(JNIObjectHandle handle) {
        if (handle.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return null;
        }
        if (JNIObjectHandles.isInLocalRange(handle)) {
            return (T)JNIObjectHandles.getLocals().getObject(JNIObjectHandles.decodeLocal(handle));
        }
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            return JNIImageHeapHandles.getObject(handle);
        }
        if (JNIGlobalHandles.isInRange(handle)) {
            return JNIGlobalHandles.getObject(handle);
        }
        throw new RuntimeException("Invalid object handle");
    }

    public static JNIObjectRefType getHandleType(JNIObjectHandle handle) {
        if (JNIObjectHandles.isInLocalRange(handle)) {
            return JNIObjectRefType.Local;
        }
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            return JNIImageHeapHandles.getHandleType(handle);
        }
        if (JNIGlobalHandles.isInRange(handle)) {
            return JNIGlobalHandles.getHandleType(handle);
        }
        return JNIObjectRefType.Invalid;
    }

    public static JNIObjectHandle createLocal(Object obj) {
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInImageHeap(obj)) {
            return JNIImageHeapHandles.asLocal(obj);
        }
        return JNIObjectHandles.encodeLocal(JNIObjectHandles.getLocals().create(obj));
    }

    public static JNIObjectHandle newLocalRef(JNIObjectHandle ref) {
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(ref)) {
            return JNIImageHeapHandles.toLocal(ref);
        }
        return JNIObjectHandles.encodeLocal(JNIObjectHandles.getLocals().create(JNIObjectHandles.getObject(ref)));
    }

    public static void deleteLocalRef(JNIObjectHandle localRef) {
        if (!JNIObjectHandles.useImageHeapHandles() || !JNIImageHeapHandles.isInRange(localRef)) {
            JNIObjectHandles.getLocals().delete(JNIObjectHandles.decodeLocal(localRef));
        }
    }

    public static int pushLocalFrame(int capacity) {
        return JNIObjectHandles.getLocals().pushFrame(capacity);
    }

    public static void popLocalFrame() {
        JNIObjectHandles.getLocals().popFrame();
    }

    public static void popLocalFramesIncluding(int frame) {
        JNIObjectHandles.getLocals().popFramesIncluding(frame);
    }

    public static void ensureLocalCapacity(int capacity) {
        JNIObjectHandles.getLocals().ensureCapacity(capacity);
    }

    public static JNIObjectHandle newGlobalRef(JNIObjectHandle handle) {
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            result = JNIImageHeapHandles.toGlobal(handle);
        } else {
            Object obj = JNIObjectHandles.getObject(handle);
            if (obj != null) {
                result = JNIGlobalHandles.create(obj);
            }
        }
        return result;
    }

    public static void deleteGlobalRef(JNIObjectHandle globalRef) {
        if (!JNIObjectHandles.useImageHeapHandles() || !JNIImageHeapHandles.isInRange(globalRef)) {
            JNIGlobalHandles.destroy(globalRef);
        }
    }

    public static JNIObjectHandle newWeakGlobalRef(JNIObjectHandle handle) {
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (JNIObjectHandles.useImageHeapHandles() && JNIImageHeapHandles.isInRange(handle)) {
            result = JNIImageHeapHandles.toWeakGlobal(handle);
        } else {
            Object obj = JNIObjectHandles.getObject(handle);
            if (obj != null) {
                result = JNIGlobalHandles.createWeak(obj);
            }
        }
        return result;
    }

    public static void deleteWeakGlobalRef(JNIObjectHandle weakRef) {
        if (!JNIObjectHandles.useImageHeapHandles() || !JNIImageHeapHandles.isInRange(weakRef)) {
            JNIGlobalHandles.destroyWeak(weakRef);
        }
    }

    static int getLocalHandleCount() {
        return JNIObjectHandles.getLocals().getHandleCount();
    }

    static long computeCurrentGlobalHandleCount() {
        return JNIGlobalHandles.computeCurrentCount();
    }
}

