/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.Target_java_net_Inet6Address;
import com.oracle.svm.core.posix.Target_java_net_Inet6Address_Inet6AddressHolder;
import com.oracle.svm.core.posix.Target_java_net_InetAddress;
import com.oracle.svm.core.posix.Target_java_net_InetAddress_InetAddressHolder;
import com.oracle.svm.core.posix.Target_jni;
import com.oracle.svm.core.posix.Util_java_net_Inet4Address;
import com.oracle.svm.core.posix.Util_java_net_Inet6Address;
import com.oracle.svm.core.posix.Util_java_net_InetAddress;
import com.oracle.svm.core.posix.Util_jni;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
class JavaNetNetUtil {
    static int initialized;
    static boolean IPv6_available;
    static Boolean REUSEPORT_available;

    private JavaNetNetUtil() {
    }

    static void initInetAddrs() {
        if (!CTypeConversion.toBoolean((int)initialized)) {
            Util_java_net_InetAddress.Java_java_net_InetAddress_init();
            Util_java_net_Inet4Address.Java_java_net_Inet4Address_init();
            Util_java_net_Inet6Address.Java_java_net_Inet6Address_init();
            initialized = 1;
        }
    }

    static boolean ipv6_available() {
        return IPv6_available;
    }

    static boolean reuseport_available() {
        if (REUSEPORT_available == null) {
            REUSEPORT_available = JavaNetNetUtilMD.reuseport_supported();
        }
        return REUSEPORT_available;
    }

    static InetAddress NET_SockaddrToInetAddress(Socket.sockaddr him, CIntPointer port) {
        InetAddress iaObj;
        if (him.sa_family() == Socket.AF_INET6()) {
            NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)((Object)him);
            CCharPointer caddr = (CCharPointer)him6.sin6_addr();
            if (JavaNetNetUtil.isIPv4Mapped(caddr)) {
                iaObj = Util_java_net_Inet4Address.new_Inet4Address();
                if (iaObj == null) {
                    return null;
                }
                int address = JavaNetNetUtilMD.NET_IPv4MappedToIPv4(caddr);
                JavaNetNetUtil.setInetAddress_addr(iaObj, address);
                JavaNetNetUtil.setInetAddress_family(iaObj, Target_java_net_InetAddress.IPv4);
            } else {
                iaObj = Util_java_net_Inet6Address.new_Inet6Address();
                if (iaObj == null) {
                    return null;
                }
                int ret = JavaNetNetUtil.setInet6Address_ipaddress((Inet6Address)iaObj, him6.sin6_addr().s6_addr());
                if (ret == 0) {
                    return null;
                }
                JavaNetNetUtil.setInetAddress_family(iaObj, Target_java_net_InetAddress.IPv6);
                int scope = JavaNetNetUtilMD.getScopeID(him);
                JavaNetNetUtil.setInet6Address_scopeid((Inet6Address)iaObj, scope);
            }
            port.write(NetinetIn.ntohs(him6.sin6_port()));
        } else {
            NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)((Object)him);
            iaObj = Util_java_net_Inet4Address.new_Inet4Address();
            if (iaObj == null) {
                return null;
            }
            JavaNetNetUtil.setInetAddress_family(iaObj, Target_java_net_InetAddress.IPv4);
            JavaNetNetUtil.setInetAddress_addr(iaObj, NetinetIn.ntohl(him4.sin_addr().s_addr()));
            port.write(NetinetIn.ntohs(him4.sin_port()));
        }
        return iaObj;
    }

    static boolean NET_SockaddrEqualsInetAddress(Socket.sockaddr him, InetAddress iaObj) {
        int addrCur;
        int family = Socket.AF_INET();
        if (IsDefined.socket_AF_INET6()) {
            int n = family = JavaNetNetUtil.getInetAddress_family(iaObj) == Target_java_net_InetAddress.IPv4 ? Socket.AF_INET() : Socket.AF_INET6();
        }
        if (him.sa_family() == Socket.AF_INET6()) {
            NetinetIn.sockaddr_in6 him6 = (NetinetIn.sockaddr_in6)((Object)him);
            CCharPointer caddrNew = him6.sin6_addr().s6_addr();
            if (JavaNetNetUtil.isIPv4Mapped(caddrNew)) {
                int addrCur2;
                if (family == Socket.AF_INET6()) {
                    return false;
                }
                int addrNew = JavaNetNetUtilMD.NET_IPv4MappedToIPv4(caddrNew);
                return addrNew == (addrCur2 = JavaNetNetUtilMD.getInetAddress_addr(iaObj));
            }
            CCharPointer caddrCur = (CCharPointer)StackValue.get((int)16, CCharPointer.class);
            if (family == Socket.AF_INET()) {
                return false;
            }
            int scope = JavaNetNetUtil.getInet6Address_scopeid((Inet6Address)iaObj);
            JavaNetNetUtil.getInet6Address_ipAddress((Inet6Address)iaObj, caddrCur);
            return JavaNetNetUtilMD.NET_IsEqual(caddrCur, caddrCur) && JavaNetNetUtilMD.cmpScopeID(scope, him);
        }
        NetinetIn.sockaddr_in him4 = (NetinetIn.sockaddr_in)((Object)him);
        if (family != Socket.AF_INET()) {
            return false;
        }
        int addrNew = NetinetIn.ntohl(him4.sin_addr().s_addr());
        return addrNew == (addrCur = JavaNetNetUtilMD.getInetAddress_addr(iaObj));
    }

    static boolean isIPv4Mapped(CCharPointer caddr) {
        for (int i = 0; i < 10; ++i) {
            if (caddr.read(i) == 0) continue;
            return false;
        }
        return (caddr.read(10) & 0xFF) == 255 && (caddr.read(11) & 0xFF) == 255;
    }

    static NetworkInterface getInet6Address_scopeifname(Inet6Address iaObj) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_Inet6Address_Inet6AddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_Inet6Address.class).holder6;
        if (holder == null) {
            return null;
        }
        return holder.scope_ifname;
    }

    static int setInet6Address_scopeifname(Inet6Address iaObj, NetworkInterface scopeifname) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_Inet6Address_Inet6AddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_Inet6Address.class).holder6;
        if (holder == null) {
            return -1;
        }
        holder.scope_ifname = scopeifname;
        return Target_jni.JNI_TRUE();
    }

    static int getInet6Address_scopeid(Inet6Address iaObj) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_Inet6Address_Inet6AddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_Inet6Address.class).holder6;
        if (holder == null) {
            return -1;
        }
        return holder.scope_id;
    }

    static int setInet6Address_scopeid(Inet6Address iaObj, int scopeid) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_Inet6Address_Inet6AddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_Inet6Address.class).holder6;
        if (holder == null) {
            return Target_jni.JNI_FALSE();
        }
        holder.scope_id = scopeid;
        if (scopeid > 0) {
            holder.scope_id_set = Util_jni.JNI_TRUE();
        }
        return Target_jni.JNI_TRUE();
    }

    static int getInet6Address_ipAddress(Inet6Address iaObj, CCharPointer dest) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_Inet6Address_Inet6AddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_Inet6Address.class).holder6;
        if (holder == null) {
            return Target_jni.JNI_FALSE();
        }
        byte[] addr = holder.ipaddress;
        if (addr == null) {
            return Target_jni.JNI_FALSE();
        }
        VmPrimsJNI.GetByteArrayRegion(addr, 0, 16, dest);
        return Target_jni.JNI_TRUE();
    }

    static int setInet6Address_ipaddress(Inet6Address iaObj, CCharPointer address) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_Inet6Address_Inet6AddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_Inet6Address.class).holder6;
        if (holder == null) {
            return Target_jni.JNI_FALSE();
        }
        byte[] addr = holder.ipaddress;
        if (addr == null) {
            holder.ipaddress = addr = new byte[16];
        }
        VmPrimsJNI.SetByteArrayRegion(addr, 0, 16, address);
        return Target_jni.JNI_TRUE();
    }

    static void setInetAddress_addr(InetAddress iaObj, int address) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_InetAddress_InetAddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_InetAddress.class).holder;
        holder.address = address;
    }

    static void setInetAddress_family(InetAddress iaObj, int family) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_InetAddress_InetAddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_InetAddress.class).holder;
        holder.family = family;
    }

    static void setInetAddress_hostName(InetAddress iaObj, String host) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_InetAddress_InetAddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_InetAddress.class).holder;
        holder.hostName = host;
    }

    static int getInetAddress_family(InetAddress iaObj) {
        JavaNetNetUtil.initInetAddrs();
        Target_java_net_InetAddress_InetAddressHolder holder = SubstrateUtil.cast((Object)iaObj, Target_java_net_InetAddress.class).holder;
        return holder.family;
    }

    @Fold
    static int MAX_PACKET_LEN() {
        return 65536;
    }

    static {
        boolean preferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
        IPv6_available = JavaNetNetUtilMD.IPv6_supported() & !preferIPv4Stack;
        JavaNetNetUtilMD.platformInit();
        JavaNetNetUtilMD.parseExclusiveBindProperty();
        initialized = 0;
    }
}

