/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.InvalidInstalledCodeException;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class SubstrateInstalledCodeImpl
extends InstalledCode
implements SubstrateInstalledCode {
    public SubstrateInstalledCodeImpl(String name) {
        super(name);
    }

    public SubstrateInstalledCodeImpl(SharedRuntimeMethod method) {
        super(method.format("%H.%n#(%p)"));
    }

    public SubstrateInstalledCodeImpl(String name, SharedRuntimeMethod method) {
        super(name != null ? name : method.format("%H.%n#(%p)"));
    }

    @Override
    public void setAddress(long address, ResolvedJavaMethod method) {
        this.address = address;
        this.entryPoint = address;
    }

    @Override
    public void clearAddress() {
        this.address = 0L;
        this.entryPoint = 0L;
    }

    @Override
    public SubstrateSpeculationLog getSpeculationLog() {
        return null;
    }

    public long getStart() {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }

    public byte[] getCode() {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }

    @Override
    public void invalidate() {
        CodeInfoTable.invalidateInstalledCode(this);
    }

    public Object executeVarargs(Object ... args) throws InvalidInstalledCodeException {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }
}

