/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class RuntimeOptionFeature
implements Feature {
    private ConcurrentMap<OptionDescriptor, Boolean> reachableOptions = new ConcurrentHashMap<OptionDescriptor, Boolean>();
    private RuntimeOptionParser runtimeOptionParser;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.runtimeOptionParser = new RuntimeOptionParser();
        ImageSingletons.add(RuntimeOptionParser.class, (Object)this.runtimeOptionParser);
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        config.registerObjectReplacer(this::collectOptionKeys);
    }

    private Object collectOptionKeys(Object obj) {
        OptionKey optionKey;
        if (obj instanceof OptionKey && !((optionKey = (OptionKey)obj) instanceof HostedOptionKey)) {
            OptionDescriptor optionDescriptor = optionKey.getDescriptor();
            if (optionDescriptor == null) {
                throw VMError.shouldNotReachHere("No OptionDescriptor registered for an OptionKey. Often that is the result of an incomplete build. The registration code is generated by an annotation processor at build time, so a clean and full rebuild often helps to solve this problem");
            }
            this.reachableOptions.put(optionDescriptor, true);
        }
        return obj;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess config) {
        if (this.runtimeOptionParser.updateRuntimeOptions(this.reachableOptions.keySet())) {
            config.requireAnalysisIteration();
        }
    }
}

