/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public class FormatArrayNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<FormatArrayNode> TYPE = NodeClass.create(FormatArrayNode.class);
    @Node.Input
    protected ValueNode memory;
    @Node.Input
    protected ValueNode hub;
    @Node.Input
    protected ValueNode length;
    @Node.Input
    protected ValueNode rememberedSet;
    @Node.Input
    protected ValueNode unaligned;

    public FormatArrayNode(ValueNode memory, ValueNode hub, ValueNode length, ValueNode rememberedSet, ValueNode unaligned) {
        super(TYPE, StampFactory.objectNonNull());
        this.memory = memory;
        this.hub = hub;
        this.length = length;
        this.rememberedSet = rememberedSet;
        this.unaligned = unaligned;
    }

    public ValueNode getMemory() {
        return this.memory;
    }

    public ValueNode getHub() {
        return this.hub;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public ValueNode getRememberedSet() {
        return this.rememberedSet;
    }

    public ValueNode getUnaligned() {
        return this.unaligned;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }
}

