/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.util.GuardedAnnotationAccess;

@AutomaticFeature
public class ReflectionMetadataFeature
implements Feature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(ReflectionMetadataFeature::replacer);
    }

    private static Object replacer(Object original) {
        if (original instanceof Method) {
            Method method = (Method)original;
            method.getGenericReturnType();
        }
        if (original instanceof Executable) {
            Executable executable = (Executable)original;
            executable.getGenericParameterTypes();
            executable.getGenericExceptionTypes();
            executable.getParameters();
        }
        if (original instanceof Field) {
            Field field = (Field)original;
            field.getGenericType();
        }
        if (original instanceof AccessibleObject) {
            AccessibleObject accessibleObject = (AccessibleObject)original;
            GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)accessibleObject);
        }
        if (original instanceof Parameter) {
            Parameter parameter = (Parameter)original;
            parameter.getType();
        }
        return original;
    }
}

