/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.stack.StackOverflowCheck;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.UnsignedWord;

@Platforms(value={InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class})
class LinuxStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    LinuxStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public UnsignedWord lookupStackEnd() {
        Pthread.pthread_attr_t attr = (Pthread.pthread_attr_t)StackValue.get(Pthread.pthread_attr_t.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_getattr_np(Pthread.pthread_self(), attr), "LinuxStackOverflowSupport: pthread_getattr_np");
        WordPointer stackaddrPtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stacksizePtr = (WordPointer)StackValue.get(WordPointer.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_getstack(attr, stackaddrPtr, stacksizePtr), "LinuxStackOverflowSupport: pthread_attr_getstack");
        UnsignedWord stackaddr = (UnsignedWord)stackaddrPtr.read();
        WordPointer guardsizePtr = (WordPointer)StackValue.get(WordPointer.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_getguardsize(attr, guardsizePtr), "LinuxStackOverflowSupport: pthread_attr_getguardsize");
        UnsignedWord guardsize = (UnsignedWord)guardsizePtr.read();
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_destroy(attr), "LinuxStackOverflowSupport: pthread_attr_destroy");
        return stackaddr.add(guardsize);
    }
}

