/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class CopyingImageHeapProvider
implements ImageHeapProvider {
    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(PointerBase begin, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        Word imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get();
        Word imageHeapSize = Isolates.IMAGE_HEAP_END.get().subtract(imageHeapBegin);
        if (begin.isNonNull() && reservedSize.belowThan((UnsignedWord)imageHeapSize)) {
            return 1;
        }
        Pointer heap = VirtualMemoryProvider.get().commit(begin, (UnsignedWord)imageHeapSize, 3);
        if (heap.isNull()) {
            return 8;
        }
        MemoryUtil.copyConjointMemoryAtomic((Pointer)imageHeapBegin, heap, (UnsignedWord)imageHeapSize);
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        UnsignedWord writableBeginPageOffset = UnsignedUtils.roundDown((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get().subtract(imageHeapBegin), pageSize);
        if (writableBeginPageOffset.aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)heap, writableBeginPageOffset, 1) != 0) {
            return 9;
        }
        UnsignedWord writableEndPageOffset = UnsignedUtils.roundUp((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract(imageHeapBegin), pageSize);
        if (writableEndPageOffset.belowThan((UnsignedWord)imageHeapSize)) {
            Pointer afterWritableBoundary = heap.add(writableEndPageOffset);
            Word afterWritableSize = imageHeapSize.subtract(writableEndPageOffset);
            if (VirtualMemoryProvider.get().protect((PointerBase)afterWritableBoundary, (UnsignedWord)afterWritableSize, 1) != 0) {
                return 9;
            }
        }
        basePointer.write((WordBase)heap);
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)PointerUtils.roundUp((PointerBase)heap.add((UnsignedWord)imageHeapSize), pageSize));
        }
        return 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean canUnmapInsteadOfTearDown(PointerBase heapBase) {
        return true;
    }

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int tearDown(PointerBase heapBase) {
        Word size = Isolates.IMAGE_HEAP_END.get().subtract(Isolates.IMAGE_HEAP_BEGIN.get());
        if (VirtualMemoryProvider.get().free(heapBase, (UnsignedWord)size) != 0) {
            return 8;
        }
        return 0;
    }
}

