/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.stack.SubstrateInspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrameVisitor;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

class PhysicalStackFrameVisitor<T>
implements StackFrameVisitor {
    private ResolvedJavaMethod[] curMatchingMethods;
    private final ResolvedJavaMethod[] laterMatchingMethods;
    private int skip;
    private final InspectedFrameVisitor<T> visitor;
    protected T result;

    PhysicalStackFrameVisitor(ResolvedJavaMethod[] initialMethods, ResolvedJavaMethod[] matchingMethods, int initialSkip, InspectedFrameVisitor<T> visitor) {
        this.curMatchingMethods = initialMethods;
        this.laterMatchingMethods = matchingMethods;
        this.skip = initialSkip;
        this.visitor = visitor;
    }

    @Override
    public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
        DeoptimizedFrame.VirtualFrame virtualFrame = null;
        CodeInfoQueryResult info = null;
        FrameInfoQueryResult deoptInfo = null;
        if (deoptimizedFrame != null) {
            virtualFrame = deoptimizedFrame.getTopFrame();
        } else {
            info = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip);
            if (info == null || info.getFrameInfo() == null) {
                return true;
            }
            deoptInfo = info.getFrameInfo();
        }
        int virtualFrameIndex = 0;
        do {
            int method;
            if (virtualFrame != null) {
                assert (deoptInfo == null) : "must have either deoptimized or non-deoptimized frame information, but not both";
                method = virtualFrame.getFrameInfo().getDeoptMethodOffset();
            } else {
                method = deoptInfo.getDeoptMethodOffset();
            }
            if (PhysicalStackFrameVisitor.matches(method, this.curMatchingMethods)) {
                if (this.skip > 0) {
                    --this.skip;
                } else {
                    SubstrateInspectedFrame inspectedFrame = new SubstrateInspectedFrame(sp, ip, virtualFrame, info, deoptInfo, virtualFrameIndex);
                    this.result = this.visitor.visitFrame((InspectedFrame)inspectedFrame);
                    if (this.result != null) {
                        return false;
                    }
                    if (virtualFrame == null && inspectedFrame.virtualFrame != null) {
                        virtualFrame = inspectedFrame.virtualFrame;
                        deoptInfo = null;
                    }
                    this.curMatchingMethods = this.laterMatchingMethods;
                }
            }
            if (virtualFrame != null) {
                virtualFrame = virtualFrame.getCaller();
            } else {
                deoptInfo = deoptInfo.getCaller();
            }
            ++virtualFrameIndex;
        } while (virtualFrame != null || deoptInfo != null);
        return true;
    }

    private static boolean matches(int needle, ResolvedJavaMethod[] haystack) {
        if (haystack == null) {
            return true;
        }
        for (ResolvedJavaMethod method : haystack) {
            if (((SharedMethod)method).getDeoptOffsetInImage() != needle) continue;
            return true;
        }
        return false;
    }
}

