/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.util.VMError;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.ProcessProperties;
import sun.management.Util;

final class SubstrateRuntimeMXBean
implements RuntimeMXBean {
    private static final String MSG = "RuntimeMXBean methods";
    private long startMillis = 0L;

    SubstrateRuntimeMXBean() {
    }

    Runnable startupHook() {
        return new Runnable(){

            @Override
            public void run() {
                SubstrateRuntimeMXBean.this.startMillis = System.currentTimeMillis();
            }
        };
    }

    @Override
    public List<String> getInputArguments() {
        if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
            return ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).getInputArguments();
        }
        return Collections.emptyList();
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Runtime");
    }

    @Override
    public String getName() {
        String hostName;
        long id;
        try {
            id = ProcessProperties.getProcessID();
        }
        catch (Throwable t) {
            id = GraalServices.getGlobalTimeStamp();
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return id + "@" + hostName;
    }

    @Override
    public String getVmName() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getVmVendor() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getVmVersion() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getSpecName() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getSpecVendor() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getSpecVersion() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getManagementSpecVersion() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public String getLibraryPath() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public boolean isBootClassPathSupported() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public String getBootClassPath() {
        throw VMError.unsupportedFeature(MSG);
    }

    @Override
    public long getUptime() {
        return System.currentTimeMillis() - this.startMillis;
    }

    @Override
    public long getStartTime() {
        assert (this.startMillis > 0L) : "SubstrateRuntimeMXBean.getStartTime: Should have set SubstrateRuntimeMXBean.startMillis.";
        return this.startMillis;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        Properties sysProps = System.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keys = sysProps.stringPropertyNames();
        for (String k : keys) {
            String value = sysProps.getProperty(k);
            map.put(k, value);
        }
        return map;
    }
}

