/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class RuntimeCodeInfoAccess {
    private static final NonmovableArrayAction RELEASE_ACTION = new NonmovableArrayAction(){

        @Override
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> array) {
            NonmovableArrays.releaseUnmanagedArray(array);
        }
    };

    private RuntimeCodeInfoAccess() {
    }

    public static SubstrateInstalledCode getInstalledCode(CodeInfo info) {
        return (SubstrateInstalledCode)CodeInfoAccess.getObjectField(info, 2);
    }

    public static void setInstalledCode(CodeInfo info, SubstrateInstalledCode installedCode) {
        NonmovableObjectArray<Object> objectFields = RuntimeCodeInfoAccess.cast(info).getObjectFields();
        NonmovableArrays.setObject(objectFields, 2, installedCode);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> getCodeObserverHandles(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getCodeObserverHandles();
    }

    public static void initialize(CodeInfo info, Pointer start, int size, int tier, NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        impl.setCodeStart((CodePointer)start);
        impl.setCodeSize(WordFactory.unsigned((int)size));
        impl.setTier(tier);
        impl.setCodeObserverHandles(observerHandles);
    }

    public static void setCodeObjectConstantsInfo(CodeInfo info, NonmovableArray<Byte> refMapEncoding, long refMapIndex) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        assert (impl.getCodeStart().isNonNull());
        impl.setObjectsReferenceMapEncoding(refMapEncoding);
        impl.setObjectsReferenceMapIndex(refMapIndex);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed.")
    static void setDeoptimizationMetadata(CodeInfo info, NonmovableArray<Integer> startOffsets, NonmovableArray<Byte> encodings, NonmovableObjectArray<Object> objectConstants) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        impl.setDeoptimizationStartOffsets(startOffsets);
        impl.setDeoptimizationEncodings(encodings);
        impl.setDeoptimizationObjectConstants(objectConstants);
    }

    public static CodeInfoTether beforeInstallInCurrentIsolate(CodeInfo info, SubstrateInstalledCode installedCode) {
        CodeInfoTether tether = new CodeInfoTether(true);
        NonmovableObjectArray<Object> objectFields = RuntimeCodeInfoAccess.cast(info).getObjectFields();
        NonmovableArrays.setObject(objectFields, 0, tether);
        NonmovableArrays.setObject(objectFields, 1, installedCode.getName());
        NonmovableArrays.setObject(objectFields, 2, installedCode);
        return tether;
    }

    public static boolean walkStrongReferences(CodeInfo info, ObjectReferenceVisitor visitor) {
        return NonmovableArrays.walkUnmanagedObjectArray(RuntimeCodeInfoAccess.cast(info).getObjectFields(), visitor, 0, 2);
    }

    public static boolean walkWeakReferences(CodeInfo info, ObjectReferenceVisitor visitor) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        boolean continueVisiting = true;
        boolean bl = continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getObjectFields(), visitor, 2, 1);
        if (impl.getState() == 1) {
            continueVisiting = continueVisiting && CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)impl.getCodeStart(), impl.getObjectsReferenceMapEncoding(), impl.getObjectsReferenceMapIndex(), visitor);
        }
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoObjectConstants(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoSourceClasses(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoSourceMethodNames(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoNames(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getDeoptimizationObjectConstants(), visitor);
        return continueVisiting;
    }

    public static boolean walkObjectFields(CodeInfo info, ObjectReferenceVisitor visitor) {
        return NonmovableArrays.walkUnmanagedObjectArray(RuntimeCodeInfoAccess.cast(info).getObjectFields(), visitor);
    }

    public static CodeInfo allocateMethodInfo() {
        CodeInfoImpl info = (CodeInfoImpl)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).calloc(SizeOf.unsigned(CodeInfoImpl.class));
        NonmovableObjectArray<Object> objectFields = NonmovableArrays.createObjectArray(3);
        info.setObjectFields(objectFields);
        RuntimeCodeInfoMemory.singleton().add(info);
        return info;
    }

    static void partialReleaseAfterInvalidate(CodeInfo info) {
        InstalledCodeObserverSupport.removeObservers(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        RuntimeCodeInfoAccess.releaseMemory(info);
    }

    @Uninterruptible(reason="Prevent the GC from running - otherwise, it could accidentally visit the freed memory.")
    private static void releaseMemory(CodeInfo info) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        assert (impl.getState() == 1 || impl.getState() == 2) : "unexpected state (probably already released)";
        NonmovableArrays.releaseUnmanagedArray(impl.getCodeObserverHandles());
        impl.setCodeObserverHandles((NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle>)NonmovableArrays.nullArray());
        RuntimeCodeInfoAccess.releaseCodeMemory(impl.getCodeStart(), impl.getCodeSize());
        impl.setCodeStart((CodePointer)WordFactory.nullPointer());
        impl.setCodeSize(WordFactory.unsigned((int)0));
        CodeInfoAccess.setState(info, 3);
    }

    public static CodePointer allocateCodeMemory(UnsignedWord size) {
        return (CodePointer)CommittedMemoryProvider.get().allocate(size, WordFactory.unsigned((int)SubstrateOptions.codeAlignment()), true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void releaseCodeMemory(CodePointer codeStart, UnsignedWord codeSize) {
        CommittedMemoryProvider.get().free((PointerBase)codeStart, codeSize, WordFactory.unsigned((int)SubstrateOptions.codeAlignment()), true);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    static void releaseMethodInfoOnTearDown(CodeInfo info) {
        InstalledCodeObserverSupport.removeObserversOnTearDown(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        assert (((CodeInfoTether)UntetheredCodeInfoAccess.getTetherUnsafe(info)).getCount() == 1) : "CodeInfo tether must not be referenced by non-teardown code.";
        RuntimeCodeInfoAccess.releaseMethodInfoMemory(info);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void releaseMethodInfoMemory(CodeInfo info) {
        RuntimeCodeInfoAccess.forEachArray(info, RELEASE_ACTION);
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)info);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void forEachArray(CodeInfo info, NonmovableArrayAction action) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        action.apply(impl.getCodeInfoIndex());
        action.apply(impl.getCodeInfoEncodings());
        action.apply(impl.getReferenceMapEncoding());
        action.apply(impl.getFrameInfoEncodings());
        action.apply(impl.getDeoptimizationStartOffsets());
        action.apply(impl.getDeoptimizationEncodings());
        action.apply(impl.getObjectsReferenceMapEncoding());
        action.apply(impl.getCodeObserverHandles());
        RuntimeCodeInfoAccess.forEachObjectArray(info, action);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void forEachObjectArray(CodeInfo info, NonmovableArrayAction action) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        action.apply(impl.getObjectFields());
        action.apply(impl.getFrameInfoObjectConstants());
        action.apply(impl.getFrameInfoSourceClasses());
        action.apply(impl.getFrameInfoSourceMethodNames());
        action.apply(impl.getFrameInfoNames());
        action.apply(impl.getDeoptimizationObjectConstants());
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    private static CodeInfoImpl cast(CodeInfo info) {
        assert (CodeInfoAccess.isValid(info));
        return (CodeInfoImpl)info;
    }

    public static interface NonmovableArrayAction {
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> var1);
    }
}

