/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.pthread.PthreadVMCondition;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.WordFactory;

@AutomaticFeature
@Platforms(value={InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class, InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class})
final class PthreadVMLockFeature
implements Feature {
    private final ClassInstanceReplacer<VMMutex, VMMutex> mutexReplacer = new ClassInstanceReplacer<VMMutex, VMMutex>(VMMutex.class){

        @Override
        protected VMMutex createReplacement(VMMutex source) {
            return new PthreadVMMutex();
        }
    };
    private final ClassInstanceReplacer<VMCondition, VMCondition> conditionReplacer = new ClassInstanceReplacer<VMCondition, VMCondition>(VMCondition.class){

        @Override
        protected VMCondition createReplacement(VMCondition source) {
            return new PthreadVMCondition((PthreadVMMutex)PthreadVMLockFeature.this.mutexReplacer.apply(source.getMutex()));
        }
    };

    PthreadVMLockFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(PthreadVMLockSupport.class, (Object)new PthreadVMLockSupport());
        access.registerObjectReplacer(this.mutexReplacer);
        access.registerObjectReplacer(this.conditionReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int nextIndex = 0;
        PthreadVMMutex[] mutexes = this.mutexReplacer.getReplacements().toArray(new PthreadVMMutex[0]);
        int mutexSize = NumUtil.roundUp((int)SizeOf.get(Pthread.pthread_mutex_t.class), (int)8);
        for (PthreadVMMutex mutex : mutexes) {
            mutex.structOffset = WordFactory.unsigned((long)layout.getArrayElementOffset(JavaKind.Byte, nextIndex));
            nextIndex += mutexSize;
        }
        PthreadVMCondition[] conditions = this.conditionReplacer.getReplacements().toArray(new PthreadVMCondition[0]);
        int conditionSize = NumUtil.roundUp((int)SizeOf.get(Pthread.pthread_cond_t.class), (int)8);
        for (PthreadVMCondition condition : conditions) {
            condition.structOffset = WordFactory.unsigned((long)layout.getArrayElementOffset(JavaKind.Byte, nextIndex));
            nextIndex += conditionSize;
        }
        PthreadVMLockSupport lockSupport = (PthreadVMLockSupport)ImageSingletons.lookup(PthreadVMLockSupport.class);
        lockSupport.mutexes = mutexes;
        lockSupport.conditions = conditions;
        lockSupport.pthreadStructs = new byte[nextIndex];
    }
}

